<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* mortgage-calculator */
class __TwigTemplate_be3bbe13bbe617d047f4484105728aa7 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context)
    {
        // line 11
        return "layouts/_main";
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        craft\helpers\Template::beginProfile("template", "mortgage-calculator");
        // line 1
        $context["title"] = "Mortgage Calculator";
        // line 2
        $context["p"] = Craft::getAlias("@web/assets");
        // line 3
        craft\helpers\Template::css(((isset($context["p"]) || array_key_exists("p", $context) ? $context["p"] : (function () { throw new RuntimeError('Variable "p" does not exist.', 3, $this->source); })()) . "/css/calculator.css"));
        // line 4
        craft\helpers\Template::css("https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,400,600,700");
        // line 6
        craft\helpers\Template::attribute($this->env, $this->source, (isset($context["view"]) || array_key_exists("view", $context) ? $context["view"] : (function () { throw new RuntimeError('Variable "view" does not exist.', 6, $this->source); })()), "registerJsFile", [0 => "https://cdnjs.cloudflare.com/ajax/libs/vue/2.2.6/vue.min.js"], "method");
        // line 7
        craft\helpers\Template::attribute($this->env, $this->source, (isset($context["view"]) || array_key_exists("view", $context) ? $context["view"] : (function () { throw new RuntimeError('Variable "view" does not exist.', 7, $this->source); })()), "registerJsFile", [0 => "https://cdnjs.cloudflare.com/ajax/libs/vue-resource/1.5.1/vue-resource.min.js"], "method");
        // line 8
        craft\helpers\Template::attribute($this->env, $this->source, (isset($context["view"]) || array_key_exists("view", $context) ? $context["view"] : (function () { throw new RuntimeError('Variable "view" does not exist.', 8, $this->source); })()), "registerJsFile", [0 => "https://unpkg.com/vue-chartjs@2.5.7-rc3/dist/vue-chartjs.full.min.js"], "method");
        // line 11
        $this->parent = $this->loadTemplate("layouts/_main", "mortgage-calculator", 11);
        $this->parent->display($context, array_merge($this->blocks, $blocks));
        craft\helpers\Template::endProfile("template", "mortgage-calculator");
    }

    // line 14
    public function block_content($context, array $blocks = [])
    {
        $macros = $this->macros;
        craft\helpers\Template::beginProfile("block", "content");
        // line 15
        echo "  <div class=\"container first-container\">\t
    <h1>Mortgage Calculator (Business)</h1>
      <section class=\"pb-5\">
      <div id=\"calculator\">

        <!-- inputs -->
        <div id=\"inputs\" :class=\"{ visible: visible }\" v-cloak>
          <div id=\"price\" class=\"input-group\">
            <label for=\"price\">Home price</label>
            <input type=\"text\" v-model=\"price\" @keyup=\"checkPrice\" @blur=\"onBlurPrice\" />
          </div>
          <div id=\"upfront\" class=\"input-group\">
            <label for=\"upfront\">Down payment ({( upfront )}%)</label>
            <input type=\"range\" min=\"0\" max=\"100\" step=\"10\" v-model=\"upfront\" />
          </div>
          <div id=\"rate\" class=\"input-group\">
            <label for=\"rate\">Interest rate</label>
            <div>
              <input type=\"text\" v-model.lazy=\"rate\" @keyup.enter=\"checkRate\" @blur=\"checkRate\" />
            </div>
          </div>
          <div id=\"term\" class=\"input-group\">
            <label for=\"term\">Loan term</label>
            <div>
              <select v-model=\"term\">
                <option v-for=\"term in terms\" :value=\"term.value\">{( term.text )}</option>
              </select>
            </div>
          </div>
          <div id=\"save\" class=\"input-group\">
            <button @click=\"saveSettings\">{( button )}</button>
          </div>
        </div><!-- #inputs -->

        <!-- results -->
        <div id=\"results\" :class=\"{ visible: visible }\" v-cloak>
          <ul id=\"details\">
            <li>
              <h5>Monthly payment*</h5>
              <div v-html=\"toCurrency(payment)\"></div>
            </li>
            <li>
              <h5>Total payments</h5>
              <div v-if=\"priceInt\">{( months )} monthly payments</div>
              <div v-else>&ndash;&ndash;</div>
            </li>
            <li>
              <h5>Down payment ({( upfront )}%)</h5>
              <div v-html=\"toCurrency(down, 0)\"></div>
            </li>
            <li>
              <h5>Principal</h5>
              <div v-html=\"toCurrency(loan, 0)\"></div>
            </li>
            <li>
              <h5>Total interest paid</h5>
              <div v-html=\"toCurrency(interest, 0)\"></div>
            </li>
            <li>
              <h5>Total mortgage cost*</h5>
              <div v-html=\"toCurrency(total, 0)\"></div>
            </li>
            <li>
              <div>*Estimated, not including taxes and insurance.</div>
            </li>
          </ul>
          <div id=\"chart\">
            <div><pie-chart :data=\"chartData\" :animate=\"animate\"></pie-chart></div>
          </div>
        </div><!-- #results -->

      </div>
      </section>
    

    ";
        // line 90
        $context["p"] = Craft::getAlias("@web/assets/js");
        echo " 
    ";
        // line 91
        craft\helpers\Template::attribute($this->env, $this->source, (isset($context["view"]) || array_key_exists("view", $context) ? $context["view"] : (function () { throw new RuntimeError('Variable "view" does not exist.', 91, $this->source); })()), "registerJsFile", [0 => ((isset($context["p"]) || array_key_exists("p", $context) ? $context["p"] : (function () { throw new RuntimeError('Variable "p" does not exist.', 91, $this->source); })()) . "/calculator.js")], "method");
        // line 92
        echo "  </div>
";
        craft\helpers\Template::endProfile("block", "content");
    }

    public function getTemplateName()
    {
        return "mortgage-calculator";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  151 => 92,  149 => 91,  145 => 90,  68 => 15,  63 => 14,  57 => 11,  55 => 8,  53 => 7,  51 => 6,  49 => 4,  47 => 3,  45 => 2,  43 => 1,  35 => 11,);
    }

    public function getSourceContext()
    {
        return new Source("{% set title = 'Mortgage Calculator' %}
{% set p = alias('@web/assets') %} 
{% css p ~ \"/css/calculator.css\" %}
{% css \"https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,400,600,700\" %}

{% do view.registerJsFile(\"https://cdnjs.cloudflare.com/ajax/libs/vue/2.2.6/vue.min.js\") %}
{% do view.registerJsFile(\"https://cdnjs.cloudflare.com/ajax/libs/vue-resource/1.5.1/vue-resource.min.js\") %}
{% do view.registerJsFile(\"https://unpkg.com/vue-chartjs@2.5.7-rc3/dist/vue-chartjs.full.min.js\") %}


{% extends 'layouts/_main' %}


{% block content %}
  <div class=\"container first-container\">\t
    <h1>Mortgage Calculator (Business)</h1>
      <section class=\"pb-5\">
      <div id=\"calculator\">

        <!-- inputs -->
        <div id=\"inputs\" :class=\"{ visible: visible }\" v-cloak>
          <div id=\"price\" class=\"input-group\">
            <label for=\"price\">Home price</label>
            <input type=\"text\" v-model=\"price\" @keyup=\"checkPrice\" @blur=\"onBlurPrice\" />
          </div>
          <div id=\"upfront\" class=\"input-group\">
            <label for=\"upfront\">Down payment ({( upfront )}%)</label>
            <input type=\"range\" min=\"0\" max=\"100\" step=\"10\" v-model=\"upfront\" />
          </div>
          <div id=\"rate\" class=\"input-group\">
            <label for=\"rate\">Interest rate</label>
            <div>
              <input type=\"text\" v-model.lazy=\"rate\" @keyup.enter=\"checkRate\" @blur=\"checkRate\" />
            </div>
          </div>
          <div id=\"term\" class=\"input-group\">
            <label for=\"term\">Loan term</label>
            <div>
              <select v-model=\"term\">
                <option v-for=\"term in terms\" :value=\"term.value\">{( term.text )}</option>
              </select>
            </div>
          </div>
          <div id=\"save\" class=\"input-group\">
            <button @click=\"saveSettings\">{( button )}</button>
          </div>
        </div><!-- #inputs -->

        <!-- results -->
        <div id=\"results\" :class=\"{ visible: visible }\" v-cloak>
          <ul id=\"details\">
            <li>
              <h5>Monthly payment*</h5>
              <div v-html=\"toCurrency(payment)\"></div>
            </li>
            <li>
              <h5>Total payments</h5>
              <div v-if=\"priceInt\">{( months )} monthly payments</div>
              <div v-else>&ndash;&ndash;</div>
            </li>
            <li>
              <h5>Down payment ({( upfront )}%)</h5>
              <div v-html=\"toCurrency(down, 0)\"></div>
            </li>
            <li>
              <h5>Principal</h5>
              <div v-html=\"toCurrency(loan, 0)\"></div>
            </li>
            <li>
              <h5>Total interest paid</h5>
              <div v-html=\"toCurrency(interest, 0)\"></div>
            </li>
            <li>
              <h5>Total mortgage cost*</h5>
              <div v-html=\"toCurrency(total, 0)\"></div>
            </li>
            <li>
              <div>*Estimated, not including taxes and insurance.</div>
            </li>
          </ul>
          <div id=\"chart\">
            <div><pie-chart :data=\"chartData\" :animate=\"animate\"></pie-chart></div>
          </div>
        </div><!-- #results -->

      </div>
      </section>
    

    {% set p = alias('@web/assets/js') %} 
    {% do view.registerJsFile(p ~ '/calculator.js') %}
  </div>
{% endblock %}", "mortgage-calculator", "/home/addons/atweb.space/sub/craft-demo/cms/templates/mortgage-calculator.twig");
    }
}
