<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'dd.MM.yyyy',
            'time' => 'HH:mm',
            'datetime' => 'dd.MM.yyyy, HH:mm',
        ],
        'medium' => [
            'date' => 'dd.MM.y',
            'time' => 'HH:mm:ss',
            'datetime' => 'dd.MM.y, HH:mm:ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd. MMMM y \'um\' HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d. MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE, d. MMMM y \'um\' HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤ #,##0.00;¤-#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'CHF',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => '’',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => 'CHF',
        'intlCurrency' => 'CHF',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '’',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => 'EUR ',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'Jan',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez',
        ],
        'full' => [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'Jan.',
            'Feb.',
            'März',
            'Apr.',
            'Mai',
            'Juni',
            'Juli',
            'Aug.',
            'Sept.',
            'Okt.',
            'Nov.',
            'Dez.',
        ],
        'full' => [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'D',
            'M',
            'D',
            'F',
            'S',
        ],
        'short' => [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.',
        ],
        'medium' => [
            'So',
            'Mo',
            'Di',
            'Mi',
            'Do',
            'Fr',
            'Sa',
        ],
        'full' => [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'D',
            'M',
            'D',
            'F',
            'S',
        ],
        'short' => [
            'So',
            'Mo',
            'Di',
            'Mi',
            'Do',
            'Fr',
            'Sa',
        ],
        'medium' => [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.',
        ],
        'full' => [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'Afrikaans',
        'af-NA' => 'Afrikaans (Namibia)',
        'af-ZA' => 'Afrikaans (Südafrika)',
        'agq' => 'Aghem',
        'agq-CM' => 'Aghem (Kamerun)',
        'ak' => 'Akan',
        'ak-GH' => 'Akan (Ghana)',
        'am' => 'Amharisch',
        'am-ET' => 'Amharisch (Äthiopien)',
        'ar' => 'Arabisch',
        'ar-001' => 'Arabisch (Welt)',
        'ar-AE' => 'Arabisch (Vereinigte Arabische Emirate)',
        'ar-BH' => 'Arabisch (Bahrain)',
        'ar-DJ' => 'Arabisch (Dschibuti)',
        'ar-DZ' => 'Arabisch (Algerien)',
        'ar-EG' => 'Arabisch (Ägypten)',
        'ar-EH' => 'Arabisch (Westsahara)',
        'ar-ER' => 'Arabisch (Eritrea)',
        'ar-IL' => 'Arabisch (Israel)',
        'ar-IQ' => 'Arabisch (Irak)',
        'ar-JO' => 'Arabisch (Jordanien)',
        'ar-KM' => 'Arabisch (Komoren)',
        'ar-KW' => 'Arabisch (Kuwait)',
        'ar-LB' => 'Arabisch (Libanon)',
        'ar-LY' => 'Arabisch (Libyen)',
        'ar-MA' => 'Arabisch (Marokko)',
        'ar-MR' => 'Arabisch (Mauretanien)',
        'ar-OM' => 'Arabisch (Oman)',
        'ar-PS' => 'Arabisch (Palästinensische Autonomiegebiete)',
        'ar-QA' => 'Arabisch (Katar)',
        'ar-SA' => 'Arabisch (Saudi-Arabien)',
        'ar-SD' => 'Arabisch (Sudan)',
        'ar-SO' => 'Arabisch (Somalia)',
        'ar-SS' => 'Arabisch (Südsudan)',
        'ar-SY' => 'Arabisch (Syrien)',
        'ar-TD' => 'Arabisch (Tschad)',
        'ar-TN' => 'Arabisch (Tunesien)',
        'ar-YE' => 'Arabisch (Jemen)',
        'as' => 'Assamesisch',
        'as-IN' => 'Assamesisch (Indien)',
        'asa' => 'Asu',
        'asa-TZ' => 'Asu (Tansania)',
        'ast' => 'Asturianisch',
        'ast-ES' => 'Asturianisch (Spanien)',
        'az' => 'Aserbaidschanisch',
        'az-Cyrl' => 'Aserbaidschanisch (Kyrillisch)',
        'az-Cyrl-AZ' => 'Aserbaidschanisch (Kyrillisch, Aserbaidschan)',
        'az-Latn' => 'Aserbaidschanisch (Lateinisch)',
        'az-Latn-AZ' => 'Aserbaidschanisch (Lateinisch, Aserbaidschan)',
        'bas' => 'Basaa-Sprache',
        'bas-CM' => 'Basaa-Sprache (Kamerun)',
        'be' => 'Weissrussisch',
        'be-BY' => 'Weissrussisch (Weissrussland)',
        'bem' => 'Bemba',
        'bem-ZM' => 'Bemba (Sambia)',
        'bez' => 'Bena',
        'bez-TZ' => 'Bena (Tansania)',
        'bg' => 'Bulgarisch',
        'bg-BG' => 'Bulgarisch (Bulgarien)',
        'bm' => 'Bambara',
        'bm-ML' => 'Bambara (Mali)',
        'bn' => 'Bengalisch',
        'bn-BD' => 'Bengalisch (Bangladesch)',
        'bn-IN' => 'Bengalisch (Indien)',
        'bo' => 'Tibetisch',
        'bo-CN' => 'Tibetisch (China)',
        'bo-IN' => 'Tibetisch (Indien)',
        'br' => 'Bretonisch',
        'br-FR' => 'Bretonisch (Frankreich)',
        'brx' => 'Bodo',
        'brx-IN' => 'Bodo (Indien)',
        'bs' => 'Bosnisch',
        'bs-Cyrl' => 'Bosnisch (Kyrillisch)',
        'bs-Cyrl-BA' => 'Bosnisch (Kyrillisch, Bosnien und Herzegowina)',
        'bs-Latn' => 'Bosnisch (Lateinisch)',
        'bs-Latn-BA' => 'Bosnisch (Lateinisch, Bosnien und Herzegowina)',
        'ca' => 'Katalanisch',
        'ca-AD' => 'Katalanisch (Andorra)',
        'ca-ES' => 'Katalanisch (Spanien)',
        'ca-FR' => 'Katalanisch (Frankreich)',
        'ca-IT' => 'Katalanisch (Italien)',
        'ccp' => 'ccp',
        'ccp-BD' => 'ccp (Bangladesch)',
        'ccp-IN' => 'ccp (Indien)',
        'ce' => 'Tschetschenisch',
        'ce-RU' => 'Tschetschenisch (Russland)',
        'ceb' => 'Cebuano',
        'ceb-PH' => 'Cebuano (Philippinen)',
        'cgg' => 'Rukiga',
        'cgg-UG' => 'Rukiga (Uganda)',
        'chr' => 'Cherokee',
        'chr-US' => 'Cherokee (Vereinigte Staaten)',
        'ckb' => 'Zentralkurdisch',
        'ckb-IQ' => 'Zentralkurdisch (Irak)',
        'ckb-IR' => 'Zentralkurdisch (Iran)',
        'cs' => 'Tschechisch',
        'cs-CZ' => 'Tschechisch (Tschechien)',
        'cy' => 'Walisisch',
        'cy-GB' => 'Walisisch (Grossbritannien)',
        'da' => 'Dänisch',
        'da-DK' => 'Dänisch (Dänemark)',
        'da-GL' => 'Dänisch (Grönland)',
        'dav' => 'Taita',
        'dav-KE' => 'Taita (Kenia)',
        'de' => 'Deutsch',
        'de-AT' => 'Deutsch (Österreich)',
        'de-BE' => 'Deutsch (Belgien)',
        'de-CH' => 'Deutsch (Schweiz)',
        'de-DE' => 'Deutsch (Deutschland)',
        'de-IT' => 'Deutsch (Italien)',
        'de-LI' => 'Deutsch (Liechtenstein)',
        'de-LU' => 'Deutsch (Luxemburg)',
        'dje' => 'Zarma',
        'dje-NE' => 'Zarma (Niger)',
        'dsb' => 'Niedersorbisch',
        'dsb-DE' => 'Niedersorbisch (Deutschland)',
        'dua' => 'Duala',
        'dua-CM' => 'Duala (Kamerun)',
        'dyo' => 'Diola',
        'dyo-SN' => 'Diola (Senegal)',
        'dz' => 'Dzongkha',
        'dz-BT' => 'Dzongkha (Bhutan)',
        'ebu' => 'Embu',
        'ebu-KE' => 'Embu (Kenia)',
        'ee' => 'Ewe',
        'ee-GH' => 'Ewe (Ghana)',
        'ee-TG' => 'Ewe (Togo)',
        'el' => 'Griechisch',
        'el-CY' => 'Griechisch (Zypern)',
        'el-GR' => 'Griechisch (Griechenland)',
        'en' => 'Englisch',
        'en-001' => 'Englisch (Welt)',
        'en-150' => 'Englisch (Europa)',
        'en-AE' => 'Englisch (Vereinigte Arabische Emirate)',
        'en-AG' => 'Englisch (Antigua und Barbuda)',
        'en-AI' => 'Englisch (Anguilla)',
        'en-AS' => 'Englisch (Amerikanisch-Samoa)',
        'en-AT' => 'Englisch (Österreich)',
        'en-AU' => 'Englisch (Australien)',
        'en-BB' => 'Englisch (Barbados)',
        'en-BE' => 'Englisch (Belgien)',
        'en-BI' => 'Englisch (Burundi)',
        'en-BM' => 'Englisch (Bermuda)',
        'en-BS' => 'Englisch (Bahamas)',
        'en-BW' => 'Englisch (Botswana)',
        'en-BZ' => 'Englisch (Belize)',
        'en-CA' => 'Englisch (Kanada)',
        'en-CC' => 'Englisch (Kokosinseln)',
        'en-CH' => 'Englisch (Schweiz)',
        'en-CK' => 'Englisch (Cookinseln)',
        'en-CM' => 'Englisch (Kamerun)',
        'en-CX' => 'Englisch (Weihnachtsinsel)',
        'en-CY' => 'Englisch (Zypern)',
        'en-DE' => 'Englisch (Deutschland)',
        'en-DG' => 'Englisch (Diego Garcia)',
        'en-DK' => 'Englisch (Dänemark)',
        'en-DM' => 'Englisch (Dominica)',
        'en-ER' => 'Englisch (Eritrea)',
        'en-FI' => 'Englisch (Finnland)',
        'en-FJ' => 'Englisch (Fidschi)',
        'en-FK' => 'Englisch (Falklandinseln)',
        'en-FM' => 'Englisch (Mikronesien)',
        'en-GB' => 'Englisch (Grossbritannien)',
        'en-GD' => 'Englisch (Grenada)',
        'en-GG' => 'Englisch (Guernsey)',
        'en-GH' => 'Englisch (Ghana)',
        'en-GI' => 'Englisch (Gibraltar)',
        'en-GM' => 'Englisch (Gambia)',
        'en-GU' => 'Englisch (Guam)',
        'en-GY' => 'Englisch (Guyana)',
        'en-HK' => 'Englisch (Sonderverwaltungsregion Hongkong)',
        'en-IE' => 'Englisch (Irland)',
        'en-IL' => 'Englisch (Israel)',
        'en-IM' => 'Englisch (Isle of Man)',
        'en-IN' => 'Englisch (Indien)',
        'en-IO' => 'Englisch (Britisches Territorium im Indischen Ozean)',
        'en-JE' => 'Englisch (Jersey)',
        'en-JM' => 'Englisch (Jamaika)',
        'en-KE' => 'Englisch (Kenia)',
        'en-KI' => 'Englisch (Kiribati)',
        'en-KN' => 'Englisch (St. Kitts und Nevis)',
        'en-KY' => 'Englisch (Kaimaninseln)',
        'en-LC' => 'Englisch (St. Lucia)',
        'en-LR' => 'Englisch (Liberia)',
        'en-LS' => 'Englisch (Lesotho)',
        'en-MG' => 'Englisch (Madagaskar)',
        'en-MH' => 'Englisch (Marshallinseln)',
        'en-MO' => 'Englisch (Sonderverwaltungsregion Macau)',
        'en-MP' => 'Englisch (Nördliche Marianen)',
        'en-MS' => 'Englisch (Montserrat)',
        'en-MT' => 'Englisch (Malta)',
        'en-MU' => 'Englisch (Mauritius)',
        'en-MW' => 'Englisch (Malawi)',
        'en-MY' => 'Englisch (Malaysia)',
        'en-NA' => 'Englisch (Namibia)',
        'en-NF' => 'Englisch (Norfolkinsel)',
        'en-NG' => 'Englisch (Nigeria)',
        'en-NL' => 'Englisch (Niederlande)',
        'en-NR' => 'Englisch (Nauru)',
        'en-NU' => 'Englisch (Niue)',
        'en-NZ' => 'Englisch (Neuseeland)',
        'en-PG' => 'Englisch (Papua-Neuguinea)',
        'en-PH' => 'Englisch (Philippinen)',
        'en-PK' => 'Englisch (Pakistan)',
        'en-PN' => 'Englisch (Pitcairninseln)',
        'en-PR' => 'Englisch (Puerto Rico)',
        'en-PW' => 'Englisch (Palau)',
        'en-RW' => 'Englisch (Ruanda)',
        'en-SB' => 'Englisch (Salomon-Inseln)',
        'en-SC' => 'Englisch (Seychellen)',
        'en-SD' => 'Englisch (Sudan)',
        'en-SE' => 'Englisch (Schweden)',
        'en-SG' => 'Englisch (Singapur)',
        'en-SH' => 'Englisch (St. Helena)',
        'en-SI' => 'Englisch (Slowenien)',
        'en-SL' => 'Englisch (Sierra Leone)',
        'en-SS' => 'Englisch (Südsudan)',
        'en-SX' => 'Englisch (Sint Maarten)',
        'en-SZ' => 'Englisch (Swasiland)',
        'en-TC' => 'Englisch (Turks- und Caicosinseln)',
        'en-TK' => 'Englisch (Tokelau)',
        'en-TO' => 'Englisch (Tonga)',
        'en-TT' => 'Englisch (Trinidad und Tobago)',
        'en-TV' => 'Englisch (Tuvalu)',
        'en-TZ' => 'Englisch (Tansania)',
        'en-UG' => 'Englisch (Uganda)',
        'en-UM' => 'Englisch (Amerikanische Überseeinseln)',
        'en-US' => 'Englisch (Vereinigte Staaten)',
        'en-US-POSIX' => 'Englisch (Vereinigte Staaten, Posix)',
        'en-VC' => 'Englisch (St. Vincent und die Grenadinen)',
        'en-VG' => 'Englisch (Britische Jungferninseln)',
        'en-VI' => 'Englisch (Amerikanische Jungferninseln)',
        'en-VU' => 'Englisch (Vanuatu)',
        'en-WS' => 'Englisch (Samoa)',
        'en-ZA' => 'Englisch (Südafrika)',
        'en-ZM' => 'Englisch (Sambia)',
        'en-ZW' => 'Englisch (Zimbabwe)',
        'eo' => 'Esperanto',
        'eo-001' => 'Esperanto (Welt)',
        'es' => 'Spanisch',
        'es-419' => 'Spanisch (Lateinamerika)',
        'es-AR' => 'Spanisch (Argentinien)',
        'es-BO' => 'Spanisch (Bolivien)',
        'es-BR' => 'Spanisch (Brasilien)',
        'es-BZ' => 'Spanisch (Belize)',
        'es-CL' => 'Spanisch (Chile)',
        'es-CO' => 'Spanisch (Kolumbien)',
        'es-CR' => 'Spanisch (Costa Rica)',
        'es-CU' => 'Spanisch (Kuba)',
        'es-DO' => 'Spanisch (Dominikanische Republik)',
        'es-EA' => 'Spanisch (Ceuta und Melilla)',
        'es-EC' => 'Spanisch (Ecuador)',
        'es-ES' => 'Spanisch (Spanien)',
        'es-GQ' => 'Spanisch (Äquatorialguinea)',
        'es-GT' => 'Spanisch (Guatemala)',
        'es-HN' => 'Spanisch (Honduras)',
        'es-IC' => 'Spanisch (Kanarische Inseln)',
        'es-MX' => 'Spanisch (Mexiko)',
        'es-NI' => 'Spanisch (Nicaragua)',
        'es-PA' => 'Spanisch (Panama)',
        'es-PE' => 'Spanisch (Peru)',
        'es-PH' => 'Spanisch (Philippinen)',
        'es-PR' => 'Spanisch (Puerto Rico)',
        'es-PY' => 'Spanisch (Paraguay)',
        'es-SV' => 'Spanisch (El Salvador)',
        'es-US' => 'Spanisch (Vereinigte Staaten)',
        'es-UY' => 'Spanisch (Uruguay)',
        'es-VE' => 'Spanisch (Venezuela)',
        'et' => 'Estnisch',
        'et-EE' => 'Estnisch (Estland)',
        'eu' => 'Baskisch',
        'eu-ES' => 'Baskisch (Spanien)',
        'ewo' => 'Ewondo',
        'ewo-CM' => 'Ewondo (Kamerun)',
        'fa' => 'Persisch',
        'fa-AF' => 'Persisch (Afghanistan)',
        'fa-IR' => 'Persisch (Iran)',
        'ff' => 'Ful',
        'ff-Latn' => 'Ful (Lateinisch)',
        'ff-Latn-BF' => 'Ful (Lateinisch, Burkina Faso)',
        'ff-Latn-CM' => 'Ful (Lateinisch, Kamerun)',
        'ff-Latn-GH' => 'Ful (Lateinisch, Ghana)',
        'ff-Latn-GM' => 'Ful (Lateinisch, Gambia)',
        'ff-Latn-GN' => 'Ful (Lateinisch, Guinea)',
        'ff-Latn-GW' => 'Ful (Lateinisch, Guinea-Bissau)',
        'ff-Latn-LR' => 'Ful (Lateinisch, Liberia)',
        'ff-Latn-MR' => 'Ful (Lateinisch, Mauretanien)',
        'ff-Latn-NE' => 'Ful (Lateinisch, Niger)',
        'ff-Latn-NG' => 'Ful (Lateinisch, Nigeria)',
        'ff-Latn-SL' => 'Ful (Lateinisch, Sierra Leone)',
        'ff-Latn-SN' => 'Ful (Lateinisch, Senegal)',
        'fi' => 'Finnisch',
        'fi-FI' => 'Finnisch (Finnland)',
        'fil' => 'Filipino',
        'fil-PH' => 'Filipino (Philippinen)',
        'fo' => 'Färöisch',
        'fo-DK' => 'Färöisch (Dänemark)',
        'fo-FO' => 'Färöisch (Färöer)',
        'fr' => 'Französisch',
        'fr-BE' => 'Französisch (Belgien)',
        'fr-BF' => 'Französisch (Burkina Faso)',
        'fr-BI' => 'Französisch (Burundi)',
        'fr-BJ' => 'Französisch (Benin)',
        'fr-BL' => 'Französisch (St. Barthélemy)',
        'fr-CA' => 'Französisch (Kanada)',
        'fr-CD' => 'Französisch (Kongo-Kinshasa)',
        'fr-CF' => 'Französisch (Zentralafrikanische Republik)',
        'fr-CG' => 'Französisch (Kongo-Brazzaville)',
        'fr-CH' => 'Französisch (Schweiz)',
        'fr-CI' => 'Französisch (Côte d’Ivoire)',
        'fr-CM' => 'Französisch (Kamerun)',
        'fr-DJ' => 'Französisch (Dschibuti)',
        'fr-DZ' => 'Französisch (Algerien)',
        'fr-FR' => 'Französisch (Frankreich)',
        'fr-GA' => 'Französisch (Gabun)',
        'fr-GF' => 'Französisch (Französisch-Guayana)',
        'fr-GN' => 'Französisch (Guinea)',
        'fr-GP' => 'Französisch (Guadeloupe)',
        'fr-GQ' => 'Französisch (Äquatorialguinea)',
        'fr-HT' => 'Französisch (Haiti)',
        'fr-KM' => 'Französisch (Komoren)',
        'fr-LU' => 'Französisch (Luxemburg)',
        'fr-MA' => 'Französisch (Marokko)',
        'fr-MC' => 'Französisch (Monaco)',
        'fr-MF' => 'Französisch (St. Martin)',
        'fr-MG' => 'Französisch (Madagaskar)',
        'fr-ML' => 'Französisch (Mali)',
        'fr-MQ' => 'Französisch (Martinique)',
        'fr-MR' => 'Französisch (Mauretanien)',
        'fr-MU' => 'Französisch (Mauritius)',
        'fr-NC' => 'Französisch (Neukaledonien)',
        'fr-NE' => 'Französisch (Niger)',
        'fr-PF' => 'Französisch (Französisch-Polynesien)',
        'fr-PM' => 'Französisch (St. Pierre und Miquelon)',
        'fr-RE' => 'Französisch (Réunion)',
        'fr-RW' => 'Französisch (Ruanda)',
        'fr-SC' => 'Französisch (Seychellen)',
        'fr-SN' => 'Französisch (Senegal)',
        'fr-SY' => 'Französisch (Syrien)',
        'fr-TD' => 'Französisch (Tschad)',
        'fr-TG' => 'Französisch (Togo)',
        'fr-TN' => 'Französisch (Tunesien)',
        'fr-VU' => 'Französisch (Vanuatu)',
        'fr-WF' => 'Französisch (Wallis und Futuna)',
        'fr-YT' => 'Französisch (Mayotte)',
        'fur' => 'Friaulisch',
        'fur-IT' => 'Friaulisch (Italien)',
        'fy' => 'Westfriesisch',
        'fy-NL' => 'Westfriesisch (Niederlande)',
        'ga' => 'Irisch',
        'ga-IE' => 'Irisch (Irland)',
        'gd' => 'Schottisches Gälisch',
        'gd-GB' => 'Schottisches Gälisch (Grossbritannien)',
        'gl' => 'Galicisch',
        'gl-ES' => 'Galicisch (Spanien)',
        'gsw' => 'Schweizerdeutsch',
        'gsw-CH' => 'Schweizerdeutsch (Schweiz)',
        'gsw-FR' => 'Schweizerdeutsch (Frankreich)',
        'gsw-LI' => 'Schweizerdeutsch (Liechtenstein)',
        'gu' => 'Gujarati',
        'gu-IN' => 'Gujarati (Indien)',
        'guz' => 'Gusii',
        'guz-KE' => 'Gusii (Kenia)',
        'gv' => 'Manx',
        'gv-IM' => 'Manx (Isle of Man)',
        'ha' => 'Haussa',
        'ha-GH' => 'Haussa (Ghana)',
        'ha-NE' => 'Haussa (Niger)',
        'ha-NG' => 'Haussa (Nigeria)',
        'haw' => 'Hawaiisch',
        'haw-US' => 'Hawaiisch (Vereinigte Staaten)',
        'he' => 'Hebräisch',
        'he-IL' => 'Hebräisch (Israel)',
        'hi' => 'Hindi',
        'hi-IN' => 'Hindi (Indien)',
        'hr' => 'Kroatisch',
        'hr-BA' => 'Kroatisch (Bosnien und Herzegowina)',
        'hr-HR' => 'Kroatisch (Kroatien)',
        'hsb' => 'Obersorbisch',
        'hsb-DE' => 'Obersorbisch (Deutschland)',
        'hu' => 'Ungarisch',
        'hu-HU' => 'Ungarisch (Ungarn)',
        'hy' => 'Armenisch',
        'hy-AM' => 'Armenisch (Armenien)',
        'ia' => 'Interlingua',
        'ia-001' => 'Interlingua (Welt)',
        'id' => 'Indonesisch',
        'id-ID' => 'Indonesisch (Indonesien)',
        'ig' => 'Igbo',
        'ig-NG' => 'Igbo (Nigeria)',
        'ii' => 'Yi',
        'ii-CN' => 'Yi (China)',
        'is' => 'Isländisch',
        'is-IS' => 'Isländisch (Island)',
        'it' => 'Italienisch',
        'it-CH' => 'Italienisch (Schweiz)',
        'it-IT' => 'Italienisch (Italien)',
        'it-SM' => 'Italienisch (San Marino)',
        'it-VA' => 'Italienisch (Vatikanstadt)',
        'ja' => 'Japanisch',
        'ja-JP' => 'Japanisch (Japan)',
        'jgo' => 'Ngomba',
        'jgo-CM' => 'Ngomba (Kamerun)',
        'jmc' => 'Machame',
        'jmc-TZ' => 'Machame (Tansania)',
        'jv' => 'Javanisch',
        'jv-ID' => 'Javanisch (Indonesien)',
        'ka' => 'Georgisch',
        'ka-GE' => 'Georgisch (Georgien)',
        'kab' => 'Kabylisch',
        'kab-DZ' => 'Kabylisch (Algerien)',
        'kam' => 'Kamba',
        'kam-KE' => 'Kamba (Kenia)',
        'kde' => 'Makonde',
        'kde-TZ' => 'Makonde (Tansania)',
        'kea' => 'Kabuverdianu',
        'kea-CV' => 'Kabuverdianu (Kapverden)',
        'khq' => 'Koyra Chiini',
        'khq-ML' => 'Koyra Chiini (Mali)',
        'ki' => 'Kikuyu',
        'ki-KE' => 'Kikuyu (Kenia)',
        'kk' => 'Kasachisch',
        'kk-KZ' => 'Kasachisch (Kasachstan)',
        'kkj' => 'Kako',
        'kkj-CM' => 'Kako (Kamerun)',
        'kl' => 'Grönländisch',
        'kl-GL' => 'Grönländisch (Grönland)',
        'kln' => 'Kalenjin',
        'kln-KE' => 'Kalenjin (Kenia)',
        'km' => 'Khmer',
        'km-KH' => 'Khmer (Kambodscha)',
        'kn' => 'Kannada',
        'kn-IN' => 'Kannada (Indien)',
        'ko' => 'Koreanisch',
        'ko-KP' => 'Koreanisch (Nordkorea)',
        'ko-KR' => 'Koreanisch (Südkorea)',
        'kok' => 'Konkani',
        'kok-IN' => 'Konkani (Indien)',
        'ks' => 'Kaschmiri',
        'ks-IN' => 'Kaschmiri (Indien)',
        'ksb' => 'Shambala',
        'ksb-TZ' => 'Shambala (Tansania)',
        'ksf' => 'Bafia',
        'ksf-CM' => 'Bafia (Kamerun)',
        'ksh' => 'Kölsch',
        'ksh-DE' => 'Kölsch (Deutschland)',
        'ku' => 'Kurdisch',
        'ku-TR' => 'Kurdisch (Türkei)',
        'kw' => 'Kornisch',
        'kw-GB' => 'Kornisch (Grossbritannien)',
        'ky' => 'Kirgisisch',
        'ky-KG' => 'Kirgisisch (Kirgisistan)',
        'lag' => 'Langi',
        'lag-TZ' => 'Langi (Tansania)',
        'lb' => 'Luxemburgisch',
        'lb-LU' => 'Luxemburgisch (Luxemburg)',
        'lg' => 'Ganda',
        'lg-UG' => 'Ganda (Uganda)',
        'lkt' => 'Lakota',
        'lkt-US' => 'Lakota (Vereinigte Staaten)',
        'ln' => 'Lingala',
        'ln-AO' => 'Lingala (Angola)',
        'ln-CD' => 'Lingala (Kongo-Kinshasa)',
        'ln-CF' => 'Lingala (Zentralafrikanische Republik)',
        'ln-CG' => 'Lingala (Kongo-Brazzaville)',
        'lo' => 'Laotisch',
        'lo-LA' => 'Laotisch (Laos)',
        'lrc' => 'Nördliches Luri',
        'lrc-IQ' => 'Nördliches Luri (Irak)',
        'lrc-IR' => 'Nördliches Luri (Iran)',
        'lt' => 'Litauisch',
        'lt-LT' => 'Litauisch (Litauen)',
        'lu' => 'Luba-Katanga',
        'lu-CD' => 'Luba-Katanga (Kongo-Kinshasa)',
        'luo' => 'Luo',
        'luo-KE' => 'Luo (Kenia)',
        'luy' => 'Luhya',
        'luy-KE' => 'Luhya (Kenia)',
        'lv' => 'Lettisch',
        'lv-LV' => 'Lettisch (Lettland)',
        'mas' => 'Massai',
        'mas-KE' => 'Massai (Kenia)',
        'mas-TZ' => 'Massai (Tansania)',
        'mer' => 'Meru',
        'mer-KE' => 'Meru (Kenia)',
        'mfe' => 'Morisyen',
        'mfe-MU' => 'Morisyen (Mauritius)',
        'mg' => 'Madagassisch',
        'mg-MG' => 'Madagassisch (Madagaskar)',
        'mgh' => 'Makhuwa-Meetto',
        'mgh-MZ' => 'Makhuwa-Meetto (Mosambik)',
        'mgo' => 'Meta’',
        'mgo-CM' => 'Meta’ (Kamerun)',
        'mi' => 'Maori',
        'mi-NZ' => 'Maori (Neuseeland)',
        'mk' => 'Mazedonisch',
        'mk-MK' => 'Mazedonisch (Nordmazedonien)',
        'ml' => 'Malayalam',
        'ml-IN' => 'Malayalam (Indien)',
        'mn' => 'Mongolisch',
        'mn-MN' => 'Mongolisch (Mongolei)',
        'mr' => 'Marathi',
        'mr-IN' => 'Marathi (Indien)',
        'ms' => 'Malaiisch',
        'ms-BN' => 'Malaiisch (Brunei)',
        'ms-MY' => 'Malaiisch (Malaysia)',
        'ms-SG' => 'Malaiisch (Singapur)',
        'mt' => 'Maltesisch',
        'mt-MT' => 'Maltesisch (Malta)',
        'mua' => 'Mundang',
        'mua-CM' => 'Mundang (Kamerun)',
        'my' => 'Birmanisch',
        'my-MM' => 'Birmanisch (Myanmar)',
        'mzn' => 'Masanderanisch',
        'mzn-IR' => 'Masanderanisch (Iran)',
        'naq' => 'Nama',
        'naq-NA' => 'Nama (Namibia)',
        'nb' => 'Norwegisch Bokmål',
        'nb-NO' => 'Norwegisch Bokmål (Norwegen)',
        'nb-SJ' => 'Norwegisch Bokmål (Spitzbergen und Jan Mayen)',
        'nd' => 'Nord-Ndebele',
        'nd-ZW' => 'Nord-Ndebele (Zimbabwe)',
        'nds' => 'Niederdeutsch',
        'nds-DE' => 'Niederdeutsch (Deutschland)',
        'nds-NL' => 'Niederdeutsch (Niederlande)',
        'ne' => 'Nepalesisch',
        'ne-IN' => 'Nepalesisch (Indien)',
        'ne-NP' => 'Nepalesisch (Nepal)',
        'nl' => 'Niederländisch',
        'nl-AW' => 'Niederländisch (Aruba)',
        'nl-BE' => 'Niederländisch (Belgien)',
        'nl-BQ' => 'Niederländisch (Bonaire, Sint Eustatius und Saba)',
        'nl-CW' => 'Niederländisch (Curaçao)',
        'nl-NL' => 'Niederländisch (Niederlande)',
        'nl-SR' => 'Niederländisch (Suriname)',
        'nl-SX' => 'Niederländisch (Sint Maarten)',
        'nmg' => 'Kwasio',
        'nmg-CM' => 'Kwasio (Kamerun)',
        'nn' => 'Norwegisch Nynorsk',
        'nn-NO' => 'Norwegisch Nynorsk (Norwegen)',
        'nnh' => 'Ngiemboon',
        'nnh-CM' => 'Ngiemboon (Kamerun)',
        'nus' => 'Nuer',
        'nus-SS' => 'Nuer (Südsudan)',
        'nyn' => 'Nyankole',
        'nyn-UG' => 'Nyankole (Uganda)',
        'om' => 'Oromo',
        'om-ET' => 'Oromo (Äthiopien)',
        'om-KE' => 'Oromo (Kenia)',
        'or' => 'Oriya',
        'or-IN' => 'Oriya (Indien)',
        'os' => 'Ossetisch',
        'os-GE' => 'Ossetisch (Georgien)',
        'os-RU' => 'Ossetisch (Russland)',
        'pa' => 'Punjabi',
        'pa-Arab' => 'Punjabi (Arabisch)',
        'pa-Arab-PK' => 'Punjabi (Arabisch, Pakistan)',
        'pa-Guru' => 'Punjabi (Gurmukhi)',
        'pa-Guru-IN' => 'Punjabi (Gurmukhi, Indien)',
        'pl' => 'Polnisch',
        'pl-PL' => 'Polnisch (Polen)',
        'ps' => 'Paschtu',
        'ps-AF' => 'Paschtu (Afghanistan)',
        'ps-PK' => 'Paschtu (Pakistan)',
        'pt' => 'Portugiesisch',
        'pt-AO' => 'Portugiesisch (Angola)',
        'pt-BR' => 'Portugiesisch (Brasilien)',
        'pt-CH' => 'Portugiesisch (Schweiz)',
        'pt-CV' => 'Portugiesisch (Kapverden)',
        'pt-GQ' => 'Portugiesisch (Äquatorialguinea)',
        'pt-GW' => 'Portugiesisch (Guinea-Bissau)',
        'pt-LU' => 'Portugiesisch (Luxemburg)',
        'pt-MO' => 'Portugiesisch (Sonderverwaltungsregion Macau)',
        'pt-MZ' => 'Portugiesisch (Mosambik)',
        'pt-PT' => 'Portugiesisch (Portugal)',
        'pt-ST' => 'Portugiesisch (São Tomé und Príncipe)',
        'pt-TL' => 'Portugiesisch (Osttimor)',
        'qu' => 'Quechua',
        'qu-BO' => 'Quechua (Bolivien)',
        'qu-EC' => 'Quechua (Ecuador)',
        'qu-PE' => 'Quechua (Peru)',
        'rm' => 'Rätoromanisch',
        'rm-CH' => 'Rätoromanisch (Schweiz)',
        'rn' => 'Rundi',
        'rn-BI' => 'Rundi (Burundi)',
        'ro' => 'Rumänisch',
        'ro-MD' => 'Rumänisch (Republik Moldau)',
        'ro-RO' => 'Rumänisch (Rumänien)',
        'rof' => 'Rombo',
        'rof-TZ' => 'Rombo (Tansania)',
        'ru' => 'Russisch',
        'ru-BY' => 'Russisch (Weissrussland)',
        'ru-KG' => 'Russisch (Kirgisistan)',
        'ru-KZ' => 'Russisch (Kasachstan)',
        'ru-MD' => 'Russisch (Republik Moldau)',
        'ru-RU' => 'Russisch (Russland)',
        'ru-UA' => 'Russisch (Ukraine)',
        'rw' => 'Kinyarwanda',
        'rw-RW' => 'Kinyarwanda (Ruanda)',
        'rwk' => 'Rwa',
        'rwk-TZ' => 'Rwa (Tansania)',
        'sah' => 'Jakutisch',
        'sah-RU' => 'Jakutisch (Russland)',
        'saq' => 'Samburu',
        'saq-KE' => 'Samburu (Kenia)',
        'sbp' => 'Sangu',
        'sbp-TZ' => 'Sangu (Tansania)',
        'sd' => 'Sindhi',
        'sd-PK' => 'Sindhi (Pakistan)',
        'se' => 'Nordsamisch',
        'se-FI' => 'Nordsamisch (Finnland)',
        'se-NO' => 'Nordsamisch (Norwegen)',
        'se-SE' => 'Nordsamisch (Schweden)',
        'seh' => 'Sena',
        'seh-MZ' => 'Sena (Mosambik)',
        'ses' => 'Koyra Senni',
        'ses-ML' => 'Koyra Senni (Mali)',
        'sg' => 'Sango',
        'sg-CF' => 'Sango (Zentralafrikanische Republik)',
        'shi' => 'Taschelhit',
        'shi-Latn' => 'Taschelhit (Lateinisch)',
        'shi-Latn-MA' => 'Taschelhit (Lateinisch, Marokko)',
        'shi-Tfng' => 'Taschelhit (Tifinagh)',
        'shi-Tfng-MA' => 'Taschelhit (Tifinagh, Marokko)',
        'si' => 'Singhalesisch',
        'si-LK' => 'Singhalesisch (Sri Lanka)',
        'sk' => 'Slowakisch',
        'sk-SK' => 'Slowakisch (Slowakei)',
        'sl' => 'Slowenisch',
        'sl-SI' => 'Slowenisch (Slowenien)',
        'smn' => 'Inari-Samisch',
        'smn-FI' => 'Inari-Samisch (Finnland)',
        'sn' => 'Shona',
        'sn-ZW' => 'Shona (Zimbabwe)',
        'so' => 'Somali',
        'so-DJ' => 'Somali (Dschibuti)',
        'so-ET' => 'Somali (Äthiopien)',
        'so-KE' => 'Somali (Kenia)',
        'so-SO' => 'Somali (Somalia)',
        'sq' => 'Albanisch',
        'sq-AL' => 'Albanisch (Albanien)',
        'sq-MK' => 'Albanisch (Nordmazedonien)',
        'sq-XK' => 'Albanisch (Kosovo)',
        'sr' => 'Serbisch',
        'sr-Cyrl' => 'Serbisch (Kyrillisch)',
        'sr-Cyrl-BA' => 'Serbisch (Kyrillisch, Bosnien und Herzegowina)',
        'sr-Cyrl-ME' => 'Serbisch (Kyrillisch, Montenegro)',
        'sr-Cyrl-RS' => 'Serbisch (Kyrillisch, Serbien)',
        'sr-Cyrl-XK' => 'Serbisch (Kyrillisch, Kosovo)',
        'sr-Latn' => 'Serbisch (Lateinisch)',
        'sr-Latn-BA' => 'Serbisch (Lateinisch, Bosnien und Herzegowina)',
        'sr-Latn-ME' => 'Serbisch (Lateinisch, Montenegro)',
        'sr-Latn-RS' => 'Serbisch (Lateinisch, Serbien)',
        'sr-Latn-XK' => 'Serbisch (Lateinisch, Kosovo)',
        'sv' => 'Schwedisch',
        'sv-AX' => 'Schwedisch (Ålandinseln)',
        'sv-FI' => 'Schwedisch (Finnland)',
        'sv-SE' => 'Schwedisch (Schweden)',
        'sw' => 'Suaheli',
        'sw-CD' => 'Suaheli (Kongo-Kinshasa)',
        'sw-KE' => 'Suaheli (Kenia)',
        'sw-TZ' => 'Suaheli (Tansania)',
        'sw-UG' => 'Suaheli (Uganda)',
        'ta' => 'Tamil',
        'ta-IN' => 'Tamil (Indien)',
        'ta-LK' => 'Tamil (Sri Lanka)',
        'ta-MY' => 'Tamil (Malaysia)',
        'ta-SG' => 'Tamil (Singapur)',
        'te' => 'Telugu',
        'te-IN' => 'Telugu (Indien)',
        'teo' => 'Teso',
        'teo-KE' => 'Teso (Kenia)',
        'teo-UG' => 'Teso (Uganda)',
        'tg' => 'Tadschikisch',
        'tg-TJ' => 'Tadschikisch (Tadschikistan)',
        'th' => 'Thailändisch',
        'th-TH' => 'Thailändisch (Thailand)',
        'ti' => 'Tigrinya',
        'ti-ER' => 'Tigrinya (Eritrea)',
        'ti-ET' => 'Tigrinya (Äthiopien)',
        'tk' => 'Turkmenisch',
        'tk-TM' => 'Turkmenisch (Turkmenistan)',
        'to' => 'Tongaisch',
        'to-TO' => 'Tongaisch (Tonga)',
        'tr' => 'Türkisch',
        'tr-CY' => 'Türkisch (Zypern)',
        'tr-TR' => 'Türkisch (Türkei)',
        'tt' => 'Tatarisch',
        'tt-RU' => 'Tatarisch (Russland)',
        'twq' => 'Tasawaq',
        'twq-NE' => 'Tasawaq (Niger)',
        'tzm' => 'Zentralatlas-Tamazight',
        'tzm-MA' => 'Zentralatlas-Tamazight (Marokko)',
        'ug' => 'Uigurisch',
        'ug-CN' => 'Uigurisch (China)',
        'uk' => 'Ukrainisch',
        'uk-UA' => 'Ukrainisch (Ukraine)',
        'ur' => 'Urdu',
        'ur-IN' => 'Urdu (Indien)',
        'ur-PK' => 'Urdu (Pakistan)',
        'uz' => 'Usbekisch',
        'uz-Arab' => 'Usbekisch (Arabisch)',
        'uz-Arab-AF' => 'Usbekisch (Arabisch, Afghanistan)',
        'uz-Cyrl' => 'Usbekisch (Kyrillisch)',
        'uz-Cyrl-UZ' => 'Usbekisch (Kyrillisch, Usbekistan)',
        'uz-Latn' => 'Usbekisch (Lateinisch)',
        'uz-Latn-UZ' => 'Usbekisch (Lateinisch, Usbekistan)',
        'vai' => 'Vai',
        'vai-Latn' => 'Vai (Lateinisch)',
        'vai-Latn-LR' => 'Vai (Lateinisch, Liberia)',
        'vai-Vaii' => 'Vai (Vai)',
        'vai-Vaii-LR' => 'Vai (Vai, Liberia)',
        'vi' => 'Vietnamesisch',
        'vi-VN' => 'Vietnamesisch (Vietnam)',
        'vun' => 'Vunjo',
        'vun-TZ' => 'Vunjo (Tansania)',
        'wae' => 'Walliserdeutsch',
        'wae-CH' => 'Walliserdeutsch (Schweiz)',
        'wo' => 'Wolof',
        'wo-SN' => 'Wolof (Senegal)',
        'xh' => 'Xhosa',
        'xh-ZA' => 'Xhosa (Südafrika)',
        'xog' => 'Soga',
        'xog-UG' => 'Soga (Uganda)',
        'yav' => 'Yangben',
        'yav-CM' => 'Yangben (Kamerun)',
        'yi' => 'Jiddisch',
        'yi-001' => 'Jiddisch (Welt)',
        'yo' => 'Yoruba',
        'yo-BJ' => 'Yoruba (Benin)',
        'yo-NG' => 'Yoruba (Nigeria)',
        'yue' => 'Kantonesisch',
        'yue-Hans' => 'Kantonesisch (Vereinfacht)',
        'yue-Hans-CN' => 'Kantonesisch (Vereinfacht, China)',
        'yue-Hant' => 'Kantonesisch (Traditionell)',
        'yue-Hant-HK' => 'Kantonesisch (Traditionell, Sonderverwaltungsregion Hongkong)',
        'zgh' => 'Tamazight',
        'zgh-MA' => 'Tamazight (Marokko)',
        'zh' => 'Chinesisch',
        'zh-Hans' => 'Chinesisch (Vereinfacht)',
        'zh-Hans-CN' => 'Chinesisch (Vereinfacht, China)',
        'zh-Hans-HK' => 'Chinesisch (Vereinfacht, Sonderverwaltungsregion Hongkong)',
        'zh-Hans-MO' => 'Chinesisch (Vereinfacht, Sonderverwaltungsregion Macau)',
        'zh-Hans-SG' => 'Chinesisch (Vereinfacht, Singapur)',
        'zh-Hant' => 'Chinesisch (Traditionell)',
        'zh-Hant-HK' => 'Chinesisch (Traditionell, Sonderverwaltungsregion Hongkong)',
        'zh-Hant-MO' => 'Chinesisch (Traditionell, Sonderverwaltungsregion Macau)',
        'zh-Hant-TW' => 'Chinesisch (Traditionell, Taiwan)',
        'zu' => 'Zulu',
        'zu-ZA' => 'Zulu (Südafrika)',
    ],
];
