<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'M/d/yyyy',
            'time' => 'h:mm a',
            'datetime' => 'M/d/yyyy, h:mm a',
        ],
        'medium' => [
            'date' => 'MMM d, y',
            'time' => 'h:mm:ss a',
            'datetime' => 'MMM d, y, h:mm:ss a',
        ],
        'long' => [
            'date' => 'MMMM d, y',
            'time' => 'h:mm:ss a z',
            'datetime' => 'MMMM d, y \'at\' h:mm:ss a z',
        ],
        'full' => [
            'date' => 'EEEE, MMMM d, y',
            'time' => 'h:mm:ss a zzzz',
            'datetime' => 'EEEE, MMMM d, y \'at\' h:mm:ss a zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤#,##0.00',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => 'THB ',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec',
        ],
        'full' => [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec',
        ],
        'full' => [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'W',
            'T',
            'F',
            'S',
        ],
        'short' => [
            'Su',
            'Mo',
            'Tu',
            'We',
            'Th',
            'Fr',
            'Sa',
        ],
        'medium' => [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat',
        ],
        'full' => [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'W',
            'T',
            'F',
            'S',
        ],
        'short' => [
            'Su',
            'Mo',
            'Tu',
            'We',
            'Th',
            'Fr',
            'Sa',
        ],
        'medium' => [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat',
        ],
        'full' => [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'Afrikaans',
        'af-NA' => 'Afrikaans (Namibia)',
        'af-ZA' => 'Afrikaans (South Africa)',
        'agq' => 'Aghem',
        'agq-CM' => 'Aghem (Cameroon)',
        'ak' => 'Akan',
        'ak-GH' => 'Akan (Ghana)',
        'am' => 'Amharic',
        'am-ET' => 'Amharic (Ethiopia)',
        'ar' => 'Arabic',
        'ar-001' => 'Arabic (World)',
        'ar-AE' => 'Arabic (United Arab Emirates)',
        'ar-BH' => 'Arabic (Bahrain)',
        'ar-DJ' => 'Arabic (Djibouti)',
        'ar-DZ' => 'Arabic (Algeria)',
        'ar-EG' => 'Arabic (Egypt)',
        'ar-EH' => 'Arabic (Western Sahara)',
        'ar-ER' => 'Arabic (Eritrea)',
        'ar-IL' => 'Arabic (Israel)',
        'ar-IQ' => 'Arabic (Iraq)',
        'ar-JO' => 'Arabic (Jordan)',
        'ar-KM' => 'Arabic (Comoros)',
        'ar-KW' => 'Arabic (Kuwait)',
        'ar-LB' => 'Arabic (Lebanon)',
        'ar-LY' => 'Arabic (Libya)',
        'ar-MA' => 'Arabic (Morocco)',
        'ar-MR' => 'Arabic (Mauritania)',
        'ar-OM' => 'Arabic (Oman)',
        'ar-PS' => 'Arabic (Palestinian Territories)',
        'ar-QA' => 'Arabic (Qatar)',
        'ar-SA' => 'Arabic (Saudi Arabia)',
        'ar-SD' => 'Arabic (Sudan)',
        'ar-SO' => 'Arabic (Somalia)',
        'ar-SS' => 'Arabic (South Sudan)',
        'ar-SY' => 'Arabic (Syria)',
        'ar-TD' => 'Arabic (Chad)',
        'ar-TN' => 'Arabic (Tunisia)',
        'ar-YE' => 'Arabic (Yemen)',
        'as' => 'Assamese',
        'as-IN' => 'Assamese (India)',
        'asa' => 'Asu',
        'asa-TZ' => 'Asu (Tanzania)',
        'ast' => 'Asturian',
        'ast-ES' => 'Asturian (Spain)',
        'az' => 'Azerbaijani',
        'az-Cyrl' => 'Azerbaijani (Cyrillic)',
        'az-Cyrl-AZ' => 'Azerbaijani (Cyrillic, Azerbaijan)',
        'az-Latn' => 'Azerbaijani (Latin)',
        'az-Latn-AZ' => 'Azerbaijani (Latin, Azerbaijan)',
        'bas' => 'Basaa',
        'bas-CM' => 'Basaa (Cameroon)',
        'be' => 'Belarusian',
        'be-BY' => 'Belarusian (Belarus)',
        'bem' => 'Bemba',
        'bem-ZM' => 'Bemba (Zambia)',
        'bez' => 'Bena',
        'bez-TZ' => 'Bena (Tanzania)',
        'bg' => 'Bulgarian',
        'bg-BG' => 'Bulgarian (Bulgaria)',
        'bm' => 'Bambara',
        'bm-ML' => 'Bambara (Mali)',
        'bn' => 'Bangla',
        'bn-BD' => 'Bangla (Bangladesh)',
        'bn-IN' => 'Bangla (India)',
        'bo' => 'Tibetan',
        'bo-CN' => 'Tibetan (China)',
        'bo-IN' => 'Tibetan (India)',
        'br' => 'Breton',
        'br-FR' => 'Breton (France)',
        'brx' => 'Bodo',
        'brx-IN' => 'Bodo (India)',
        'bs' => 'Bosnian',
        'bs-Cyrl' => 'Bosnian (Cyrillic)',
        'bs-Cyrl-BA' => 'Bosnian (Cyrillic, Bosnia & Herzegovina)',
        'bs-Latn' => 'Bosnian (Latin)',
        'bs-Latn-BA' => 'Bosnian (Latin, Bosnia & Herzegovina)',
        'ca' => 'Catalan',
        'ca-AD' => 'Catalan (Andorra)',
        'ca-ES' => 'Catalan (Spain)',
        'ca-FR' => 'Catalan (France)',
        'ca-IT' => 'Catalan (Italy)',
        'ccp' => 'Chakma',
        'ccp-BD' => 'Chakma (Bangladesh)',
        'ccp-IN' => 'Chakma (India)',
        'ce' => 'Chechen',
        'ce-RU' => 'Chechen (Russia)',
        'ceb' => 'Cebuano',
        'ceb-PH' => 'Cebuano (Philippines)',
        'cgg' => 'Chiga',
        'cgg-UG' => 'Chiga (Uganda)',
        'chr' => 'Cherokee',
        'chr-US' => 'Cherokee (United States)',
        'ckb' => 'Central Kurdish',
        'ckb-IQ' => 'Central Kurdish (Iraq)',
        'ckb-IR' => 'Central Kurdish (Iran)',
        'cs' => 'Czech',
        'cs-CZ' => 'Czech (Czechia)',
        'cy' => 'Welsh',
        'cy-GB' => 'Welsh (United Kingdom)',
        'da' => 'Danish',
        'da-DK' => 'Danish (Denmark)',
        'da-GL' => 'Danish (Greenland)',
        'dav' => 'Taita',
        'dav-KE' => 'Taita (Kenya)',
        'de' => 'German',
        'de-AT' => 'German (Austria)',
        'de-BE' => 'German (Belgium)',
        'de-CH' => 'German (Switzerland)',
        'de-DE' => 'German (Germany)',
        'de-IT' => 'German (Italy)',
        'de-LI' => 'German (Liechtenstein)',
        'de-LU' => 'German (Luxembourg)',
        'dje' => 'Zarma',
        'dje-NE' => 'Zarma (Niger)',
        'dsb' => 'Lower Sorbian',
        'dsb-DE' => 'Lower Sorbian (Germany)',
        'dua' => 'Duala',
        'dua-CM' => 'Duala (Cameroon)',
        'dyo' => 'Jola-Fonyi',
        'dyo-SN' => 'Jola-Fonyi (Senegal)',
        'dz' => 'Dzongkha',
        'dz-BT' => 'Dzongkha (Bhutan)',
        'ebu' => 'Embu',
        'ebu-KE' => 'Embu (Kenya)',
        'ee' => 'Ewe',
        'ee-GH' => 'Ewe (Ghana)',
        'ee-TG' => 'Ewe (Togo)',
        'el' => 'Greek',
        'el-CY' => 'Greek (Cyprus)',
        'el-GR' => 'Greek (Greece)',
        'en' => 'English',
        'en-001' => 'English (World)',
        'en-150' => 'English (Europe)',
        'en-AE' => 'English (United Arab Emirates)',
        'en-AG' => 'English (Antigua & Barbuda)',
        'en-AI' => 'English (Anguilla)',
        'en-AS' => 'English (American Samoa)',
        'en-AT' => 'English (Austria)',
        'en-AU' => 'English (Australia)',
        'en-BB' => 'English (Barbados)',
        'en-BE' => 'English (Belgium)',
        'en-BI' => 'English (Burundi)',
        'en-BM' => 'English (Bermuda)',
        'en-BS' => 'English (Bahamas)',
        'en-BW' => 'English (Botswana)',
        'en-BZ' => 'English (Belize)',
        'en-CA' => 'English (Canada)',
        'en-CC' => 'English (Cocos [Keeling] Islands)',
        'en-CH' => 'English (Switzerland)',
        'en-CK' => 'English (Cook Islands)',
        'en-CM' => 'English (Cameroon)',
        'en-CX' => 'English (Christmas Island)',
        'en-CY' => 'English (Cyprus)',
        'en-DE' => 'English (Germany)',
        'en-DG' => 'English (Diego Garcia)',
        'en-DK' => 'English (Denmark)',
        'en-DM' => 'English (Dominica)',
        'en-ER' => 'English (Eritrea)',
        'en-FI' => 'English (Finland)',
        'en-FJ' => 'English (Fiji)',
        'en-FK' => 'English (Falkland Islands)',
        'en-FM' => 'English (Micronesia)',
        'en-GB' => 'English (United Kingdom)',
        'en-GD' => 'English (Grenada)',
        'en-GG' => 'English (Guernsey)',
        'en-GH' => 'English (Ghana)',
        'en-GI' => 'English (Gibraltar)',
        'en-GM' => 'English (Gambia)',
        'en-GU' => 'English (Guam)',
        'en-GY' => 'English (Guyana)',
        'en-HK' => 'English (Hong Kong SAR China)',
        'en-IE' => 'English (Ireland)',
        'en-IL' => 'English (Israel)',
        'en-IM' => 'English (Isle of Man)',
        'en-IN' => 'English (India)',
        'en-IO' => 'English (British Indian Ocean Territory)',
        'en-JE' => 'English (Jersey)',
        'en-JM' => 'English (Jamaica)',
        'en-KE' => 'English (Kenya)',
        'en-KI' => 'English (Kiribati)',
        'en-KN' => 'English (St. Kitts & Nevis)',
        'en-KY' => 'English (Cayman Islands)',
        'en-LC' => 'English (St. Lucia)',
        'en-LR' => 'English (Liberia)',
        'en-LS' => 'English (Lesotho)',
        'en-MG' => 'English (Madagascar)',
        'en-MH' => 'English (Marshall Islands)',
        'en-MO' => 'English (Macao SAR China)',
        'en-MP' => 'English (Northern Mariana Islands)',
        'en-MS' => 'English (Montserrat)',
        'en-MT' => 'English (Malta)',
        'en-MU' => 'English (Mauritius)',
        'en-MW' => 'English (Malawi)',
        'en-MY' => 'English (Malaysia)',
        'en-NA' => 'English (Namibia)',
        'en-NF' => 'English (Norfolk Island)',
        'en-NG' => 'English (Nigeria)',
        'en-NL' => 'English (Netherlands)',
        'en-NR' => 'English (Nauru)',
        'en-NU' => 'English (Niue)',
        'en-NZ' => 'English (New Zealand)',
        'en-PG' => 'English (Papua New Guinea)',
        'en-PH' => 'English (Philippines)',
        'en-PK' => 'English (Pakistan)',
        'en-PN' => 'English (Pitcairn Islands)',
        'en-PR' => 'English (Puerto Rico)',
        'en-PW' => 'English (Palau)',
        'en-RW' => 'English (Rwanda)',
        'en-SB' => 'English (Solomon Islands)',
        'en-SC' => 'English (Seychelles)',
        'en-SD' => 'English (Sudan)',
        'en-SE' => 'English (Sweden)',
        'en-SG' => 'English (Singapore)',
        'en-SH' => 'English (St. Helena)',
        'en-SI' => 'English (Slovenia)',
        'en-SL' => 'English (Sierra Leone)',
        'en-SS' => 'English (South Sudan)',
        'en-SX' => 'English (Sint Maarten)',
        'en-SZ' => 'English (Eswatini)',
        'en-TC' => 'English (Turks & Caicos Islands)',
        'en-TK' => 'English (Tokelau)',
        'en-TO' => 'English (Tonga)',
        'en-TT' => 'English (Trinidad & Tobago)',
        'en-TV' => 'English (Tuvalu)',
        'en-TZ' => 'English (Tanzania)',
        'en-UG' => 'English (Uganda)',
        'en-UM' => 'English (U.S. Outlying Islands)',
        'en-US' => 'English (United States)',
        'en-US-POSIX' => 'English (United States, Computer)',
        'en-VC' => 'English (St. Vincent & Grenadines)',
        'en-VG' => 'English (British Virgin Islands)',
        'en-VI' => 'English (U.S. Virgin Islands)',
        'en-VU' => 'English (Vanuatu)',
        'en-WS' => 'English (Samoa)',
        'en-ZA' => 'English (South Africa)',
        'en-ZM' => 'English (Zambia)',
        'en-ZW' => 'English (Zimbabwe)',
        'eo' => 'Esperanto',
        'eo-001' => 'Esperanto (World)',
        'es' => 'Spanish',
        'es-419' => 'Spanish (Latin America)',
        'es-AR' => 'Spanish (Argentina)',
        'es-BO' => 'Spanish (Bolivia)',
        'es-BR' => 'Spanish (Brazil)',
        'es-BZ' => 'Spanish (Belize)',
        'es-CL' => 'Spanish (Chile)',
        'es-CO' => 'Spanish (Colombia)',
        'es-CR' => 'Spanish (Costa Rica)',
        'es-CU' => 'Spanish (Cuba)',
        'es-DO' => 'Spanish (Dominican Republic)',
        'es-EA' => 'Spanish (Ceuta & Melilla)',
        'es-EC' => 'Spanish (Ecuador)',
        'es-ES' => 'Spanish (Spain)',
        'es-GQ' => 'Spanish (Equatorial Guinea)',
        'es-GT' => 'Spanish (Guatemala)',
        'es-HN' => 'Spanish (Honduras)',
        'es-IC' => 'Spanish (Canary Islands)',
        'es-MX' => 'Spanish (Mexico)',
        'es-NI' => 'Spanish (Nicaragua)',
        'es-PA' => 'Spanish (Panama)',
        'es-PE' => 'Spanish (Peru)',
        'es-PH' => 'Spanish (Philippines)',
        'es-PR' => 'Spanish (Puerto Rico)',
        'es-PY' => 'Spanish (Paraguay)',
        'es-SV' => 'Spanish (El Salvador)',
        'es-US' => 'Spanish (United States)',
        'es-UY' => 'Spanish (Uruguay)',
        'es-VE' => 'Spanish (Venezuela)',
        'et' => 'Estonian',
        'et-EE' => 'Estonian (Estonia)',
        'eu' => 'Basque',
        'eu-ES' => 'Basque (Spain)',
        'ewo' => 'Ewondo',
        'ewo-CM' => 'Ewondo (Cameroon)',
        'fa' => 'Persian',
        'fa-AF' => 'Persian (Afghanistan)',
        'fa-IR' => 'Persian (Iran)',
        'ff' => 'Fulah',
        'ff-Latn' => 'Fulah (Latin)',
        'ff-Latn-BF' => 'Fulah (Latin, Burkina Faso)',
        'ff-Latn-CM' => 'Fulah (Latin, Cameroon)',
        'ff-Latn-GH' => 'Fulah (Latin, Ghana)',
        'ff-Latn-GM' => 'Fulah (Latin, Gambia)',
        'ff-Latn-GN' => 'Fulah (Latin, Guinea)',
        'ff-Latn-GW' => 'Fulah (Latin, Guinea-Bissau)',
        'ff-Latn-LR' => 'Fulah (Latin, Liberia)',
        'ff-Latn-MR' => 'Fulah (Latin, Mauritania)',
        'ff-Latn-NE' => 'Fulah (Latin, Niger)',
        'ff-Latn-NG' => 'Fulah (Latin, Nigeria)',
        'ff-Latn-SL' => 'Fulah (Latin, Sierra Leone)',
        'ff-Latn-SN' => 'Fulah (Latin, Senegal)',
        'fi' => 'Finnish',
        'fi-FI' => 'Finnish (Finland)',
        'fil' => 'Filipino',
        'fil-PH' => 'Filipino (Philippines)',
        'fo' => 'Faroese',
        'fo-DK' => 'Faroese (Denmark)',
        'fo-FO' => 'Faroese (Faroe Islands)',
        'fr' => 'French',
        'fr-BE' => 'French (Belgium)',
        'fr-BF' => 'French (Burkina Faso)',
        'fr-BI' => 'French (Burundi)',
        'fr-BJ' => 'French (Benin)',
        'fr-BL' => 'French (St. Barthélemy)',
        'fr-CA' => 'French (Canada)',
        'fr-CD' => 'French (Congo - Kinshasa)',
        'fr-CF' => 'French (Central African Republic)',
        'fr-CG' => 'French (Congo - Brazzaville)',
        'fr-CH' => 'French (Switzerland)',
        'fr-CI' => 'French (Côte d’Ivoire)',
        'fr-CM' => 'French (Cameroon)',
        'fr-DJ' => 'French (Djibouti)',
        'fr-DZ' => 'French (Algeria)',
        'fr-FR' => 'French (France)',
        'fr-GA' => 'French (Gabon)',
        'fr-GF' => 'French (French Guiana)',
        'fr-GN' => 'French (Guinea)',
        'fr-GP' => 'French (Guadeloupe)',
        'fr-GQ' => 'French (Equatorial Guinea)',
        'fr-HT' => 'French (Haiti)',
        'fr-KM' => 'French (Comoros)',
        'fr-LU' => 'French (Luxembourg)',
        'fr-MA' => 'French (Morocco)',
        'fr-MC' => 'French (Monaco)',
        'fr-MF' => 'French (St. Martin)',
        'fr-MG' => 'French (Madagascar)',
        'fr-ML' => 'French (Mali)',
        'fr-MQ' => 'French (Martinique)',
        'fr-MR' => 'French (Mauritania)',
        'fr-MU' => 'French (Mauritius)',
        'fr-NC' => 'French (New Caledonia)',
        'fr-NE' => 'French (Niger)',
        'fr-PF' => 'French (French Polynesia)',
        'fr-PM' => 'French (St. Pierre & Miquelon)',
        'fr-RE' => 'French (Réunion)',
        'fr-RW' => 'French (Rwanda)',
        'fr-SC' => 'French (Seychelles)',
        'fr-SN' => 'French (Senegal)',
        'fr-SY' => 'French (Syria)',
        'fr-TD' => 'French (Chad)',
        'fr-TG' => 'French (Togo)',
        'fr-TN' => 'French (Tunisia)',
        'fr-VU' => 'French (Vanuatu)',
        'fr-WF' => 'French (Wallis & Futuna)',
        'fr-YT' => 'French (Mayotte)',
        'fur' => 'Friulian',
        'fur-IT' => 'Friulian (Italy)',
        'fy' => 'Western Frisian',
        'fy-NL' => 'Western Frisian (Netherlands)',
        'ga' => 'Irish',
        'ga-IE' => 'Irish (Ireland)',
        'gd' => 'Scottish Gaelic',
        'gd-GB' => 'Scottish Gaelic (United Kingdom)',
        'gl' => 'Galician',
        'gl-ES' => 'Galician (Spain)',
        'gsw' => 'Swiss German',
        'gsw-CH' => 'Swiss German (Switzerland)',
        'gsw-FR' => 'Swiss German (France)',
        'gsw-LI' => 'Swiss German (Liechtenstein)',
        'gu' => 'Gujarati',
        'gu-IN' => 'Gujarati (India)',
        'guz' => 'Gusii',
        'guz-KE' => 'Gusii (Kenya)',
        'gv' => 'Manx',
        'gv-IM' => 'Manx (Isle of Man)',
        'ha' => 'Hausa',
        'ha-GH' => 'Hausa (Ghana)',
        'ha-NE' => 'Hausa (Niger)',
        'ha-NG' => 'Hausa (Nigeria)',
        'haw' => 'Hawaiian',
        'haw-US' => 'Hawaiian (United States)',
        'he' => 'Hebrew',
        'he-IL' => 'Hebrew (Israel)',
        'hi' => 'Hindi',
        'hi-IN' => 'Hindi (India)',
        'hr' => 'Croatian',
        'hr-BA' => 'Croatian (Bosnia & Herzegovina)',
        'hr-HR' => 'Croatian (Croatia)',
        'hsb' => 'Upper Sorbian',
        'hsb-DE' => 'Upper Sorbian (Germany)',
        'hu' => 'Hungarian',
        'hu-HU' => 'Hungarian (Hungary)',
        'hy' => 'Armenian',
        'hy-AM' => 'Armenian (Armenia)',
        'ia' => 'Interlingua',
        'ia-001' => 'Interlingua (World)',
        'id' => 'Indonesian',
        'id-ID' => 'Indonesian (Indonesia)',
        'ig' => 'Igbo',
        'ig-NG' => 'Igbo (Nigeria)',
        'ii' => 'Sichuan Yi',
        'ii-CN' => 'Sichuan Yi (China)',
        'is' => 'Icelandic',
        'is-IS' => 'Icelandic (Iceland)',
        'it' => 'Italian',
        'it-CH' => 'Italian (Switzerland)',
        'it-IT' => 'Italian (Italy)',
        'it-SM' => 'Italian (San Marino)',
        'it-VA' => 'Italian (Vatican City)',
        'ja' => 'Japanese',
        'ja-JP' => 'Japanese (Japan)',
        'jgo' => 'Ngomba',
        'jgo-CM' => 'Ngomba (Cameroon)',
        'jmc' => 'Machame',
        'jmc-TZ' => 'Machame (Tanzania)',
        'jv' => 'Javanese',
        'jv-ID' => 'Javanese (Indonesia)',
        'ka' => 'Georgian',
        'ka-GE' => 'Georgian (Georgia)',
        'kab' => 'Kabyle',
        'kab-DZ' => 'Kabyle (Algeria)',
        'kam' => 'Kamba',
        'kam-KE' => 'Kamba (Kenya)',
        'kde' => 'Makonde',
        'kde-TZ' => 'Makonde (Tanzania)',
        'kea' => 'Kabuverdianu',
        'kea-CV' => 'Kabuverdianu (Cape Verde)',
        'khq' => 'Koyra Chiini',
        'khq-ML' => 'Koyra Chiini (Mali)',
        'ki' => 'Kikuyu',
        'ki-KE' => 'Kikuyu (Kenya)',
        'kk' => 'Kazakh',
        'kk-KZ' => 'Kazakh (Kazakhstan)',
        'kkj' => 'Kako',
        'kkj-CM' => 'Kako (Cameroon)',
        'kl' => 'Kalaallisut',
        'kl-GL' => 'Kalaallisut (Greenland)',
        'kln' => 'Kalenjin',
        'kln-KE' => 'Kalenjin (Kenya)',
        'km' => 'Khmer',
        'km-KH' => 'Khmer (Cambodia)',
        'kn' => 'Kannada',
        'kn-IN' => 'Kannada (India)',
        'ko' => 'Korean',
        'ko-KP' => 'Korean (North Korea)',
        'ko-KR' => 'Korean (South Korea)',
        'kok' => 'Konkani',
        'kok-IN' => 'Konkani (India)',
        'ks' => 'Kashmiri',
        'ks-IN' => 'Kashmiri (India)',
        'ksb' => 'Shambala',
        'ksb-TZ' => 'Shambala (Tanzania)',
        'ksf' => 'Bafia',
        'ksf-CM' => 'Bafia (Cameroon)',
        'ksh' => 'Colognian',
        'ksh-DE' => 'Colognian (Germany)',
        'ku' => 'Kurdish',
        'ku-TR' => 'Kurdish (Turkey)',
        'kw' => 'Cornish',
        'kw-GB' => 'Cornish (United Kingdom)',
        'ky' => 'Kyrgyz',
        'ky-KG' => 'Kyrgyz (Kyrgyzstan)',
        'lag' => 'Langi',
        'lag-TZ' => 'Langi (Tanzania)',
        'lb' => 'Luxembourgish',
        'lb-LU' => 'Luxembourgish (Luxembourg)',
        'lg' => 'Ganda',
        'lg-UG' => 'Ganda (Uganda)',
        'lkt' => 'Lakota',
        'lkt-US' => 'Lakota (United States)',
        'ln' => 'Lingala',
        'ln-AO' => 'Lingala (Angola)',
        'ln-CD' => 'Lingala (Congo - Kinshasa)',
        'ln-CF' => 'Lingala (Central African Republic)',
        'ln-CG' => 'Lingala (Congo - Brazzaville)',
        'lo' => 'Lao',
        'lo-LA' => 'Lao (Laos)',
        'lrc' => 'Northern Luri',
        'lrc-IQ' => 'Northern Luri (Iraq)',
        'lrc-IR' => 'Northern Luri (Iran)',
        'lt' => 'Lithuanian',
        'lt-LT' => 'Lithuanian (Lithuania)',
        'lu' => 'Luba-Katanga',
        'lu-CD' => 'Luba-Katanga (Congo - Kinshasa)',
        'luo' => 'Luo',
        'luo-KE' => 'Luo (Kenya)',
        'luy' => 'Luyia',
        'luy-KE' => 'Luyia (Kenya)',
        'lv' => 'Latvian',
        'lv-LV' => 'Latvian (Latvia)',
        'mas' => 'Masai',
        'mas-KE' => 'Masai (Kenya)',
        'mas-TZ' => 'Masai (Tanzania)',
        'mer' => 'Meru',
        'mer-KE' => 'Meru (Kenya)',
        'mfe' => 'Morisyen',
        'mfe-MU' => 'Morisyen (Mauritius)',
        'mg' => 'Malagasy',
        'mg-MG' => 'Malagasy (Madagascar)',
        'mgh' => 'Makhuwa-Meetto',
        'mgh-MZ' => 'Makhuwa-Meetto (Mozambique)',
        'mgo' => 'Metaʼ',
        'mgo-CM' => 'Metaʼ (Cameroon)',
        'mi' => 'Maori',
        'mi-NZ' => 'Maori (New Zealand)',
        'mk' => 'Macedonian',
        'mk-MK' => 'Macedonian (North Macedonia)',
        'ml' => 'Malayalam',
        'ml-IN' => 'Malayalam (India)',
        'mn' => 'Mongolian',
        'mn-MN' => 'Mongolian (Mongolia)',
        'mr' => 'Marathi',
        'mr-IN' => 'Marathi (India)',
        'ms' => 'Malay',
        'ms-BN' => 'Malay (Brunei)',
        'ms-MY' => 'Malay (Malaysia)',
        'ms-SG' => 'Malay (Singapore)',
        'mt' => 'Maltese',
        'mt-MT' => 'Maltese (Malta)',
        'mua' => 'Mundang',
        'mua-CM' => 'Mundang (Cameroon)',
        'my' => 'Burmese',
        'my-MM' => 'Burmese (Myanmar [Burma])',
        'mzn' => 'Mazanderani',
        'mzn-IR' => 'Mazanderani (Iran)',
        'naq' => 'Nama',
        'naq-NA' => 'Nama (Namibia)',
        'nb' => 'Norwegian Bokmål',
        'nb-NO' => 'Norwegian Bokmål (Norway)',
        'nb-SJ' => 'Norwegian Bokmål (Svalbard & Jan Mayen)',
        'nd' => 'North Ndebele',
        'nd-ZW' => 'North Ndebele (Zimbabwe)',
        'nds' => 'Low German',
        'nds-DE' => 'Low German (Germany)',
        'nds-NL' => 'Low German (Netherlands)',
        'ne' => 'Nepali',
        'ne-IN' => 'Nepali (India)',
        'ne-NP' => 'Nepali (Nepal)',
        'nl' => 'Dutch',
        'nl-AW' => 'Dutch (Aruba)',
        'nl-BE' => 'Dutch (Belgium)',
        'nl-BQ' => 'Dutch (Caribbean Netherlands)',
        'nl-CW' => 'Dutch (Curaçao)',
        'nl-NL' => 'Dutch (Netherlands)',
        'nl-SR' => 'Dutch (Suriname)',
        'nl-SX' => 'Dutch (Sint Maarten)',
        'nmg' => 'Kwasio',
        'nmg-CM' => 'Kwasio (Cameroon)',
        'nn' => 'Norwegian Nynorsk',
        'nn-NO' => 'Norwegian Nynorsk (Norway)',
        'nnh' => 'Ngiemboon',
        'nnh-CM' => 'Ngiemboon (Cameroon)',
        'nus' => 'Nuer',
        'nus-SS' => 'Nuer (South Sudan)',
        'nyn' => 'Nyankole',
        'nyn-UG' => 'Nyankole (Uganda)',
        'om' => 'Oromo',
        'om-ET' => 'Oromo (Ethiopia)',
        'om-KE' => 'Oromo (Kenya)',
        'or' => 'Odia',
        'or-IN' => 'Odia (India)',
        'os' => 'Ossetic',
        'os-GE' => 'Ossetic (Georgia)',
        'os-RU' => 'Ossetic (Russia)',
        'pa' => 'Punjabi',
        'pa-Arab' => 'Punjabi (Arabic)',
        'pa-Arab-PK' => 'Punjabi (Arabic, Pakistan)',
        'pa-Guru' => 'Punjabi (Gurmukhi)',
        'pa-Guru-IN' => 'Punjabi (Gurmukhi, India)',
        'pl' => 'Polish',
        'pl-PL' => 'Polish (Poland)',
        'ps' => 'Pashto',
        'ps-AF' => 'Pashto (Afghanistan)',
        'ps-PK' => 'Pashto (Pakistan)',
        'pt' => 'Portuguese',
        'pt-AO' => 'Portuguese (Angola)',
        'pt-BR' => 'Portuguese (Brazil)',
        'pt-CH' => 'Portuguese (Switzerland)',
        'pt-CV' => 'Portuguese (Cape Verde)',
        'pt-GQ' => 'Portuguese (Equatorial Guinea)',
        'pt-GW' => 'Portuguese (Guinea-Bissau)',
        'pt-LU' => 'Portuguese (Luxembourg)',
        'pt-MO' => 'Portuguese (Macao SAR China)',
        'pt-MZ' => 'Portuguese (Mozambique)',
        'pt-PT' => 'Portuguese (Portugal)',
        'pt-ST' => 'Portuguese (São Tomé & Príncipe)',
        'pt-TL' => 'Portuguese (Timor-Leste)',
        'qu' => 'Quechua',
        'qu-BO' => 'Quechua (Bolivia)',
        'qu-EC' => 'Quechua (Ecuador)',
        'qu-PE' => 'Quechua (Peru)',
        'rm' => 'Romansh',
        'rm-CH' => 'Romansh (Switzerland)',
        'rn' => 'Rundi',
        'rn-BI' => 'Rundi (Burundi)',
        'ro' => 'Romanian',
        'ro-MD' => 'Romanian (Moldova)',
        'ro-RO' => 'Romanian (Romania)',
        'rof' => 'Rombo',
        'rof-TZ' => 'Rombo (Tanzania)',
        'ru' => 'Russian',
        'ru-BY' => 'Russian (Belarus)',
        'ru-KG' => 'Russian (Kyrgyzstan)',
        'ru-KZ' => 'Russian (Kazakhstan)',
        'ru-MD' => 'Russian (Moldova)',
        'ru-RU' => 'Russian (Russia)',
        'ru-UA' => 'Russian (Ukraine)',
        'rw' => 'Kinyarwanda',
        'rw-RW' => 'Kinyarwanda (Rwanda)',
        'rwk' => 'Rwa',
        'rwk-TZ' => 'Rwa (Tanzania)',
        'sah' => 'Sakha',
        'sah-RU' => 'Sakha (Russia)',
        'saq' => 'Samburu',
        'saq-KE' => 'Samburu (Kenya)',
        'sbp' => 'Sangu',
        'sbp-TZ' => 'Sangu (Tanzania)',
        'sd' => 'Sindhi',
        'sd-PK' => 'Sindhi (Pakistan)',
        'se' => 'Northern Sami',
        'se-FI' => 'Northern Sami (Finland)',
        'se-NO' => 'Northern Sami (Norway)',
        'se-SE' => 'Northern Sami (Sweden)',
        'seh' => 'Sena',
        'seh-MZ' => 'Sena (Mozambique)',
        'ses' => 'Koyraboro Senni',
        'ses-ML' => 'Koyraboro Senni (Mali)',
        'sg' => 'Sango',
        'sg-CF' => 'Sango (Central African Republic)',
        'shi' => 'Tachelhit',
        'shi-Latn' => 'Tachelhit (Latin)',
        'shi-Latn-MA' => 'Tachelhit (Latin, Morocco)',
        'shi-Tfng' => 'Tachelhit (Tifinagh)',
        'shi-Tfng-MA' => 'Tachelhit (Tifinagh, Morocco)',
        'si' => 'Sinhala',
        'si-LK' => 'Sinhala (Sri Lanka)',
        'sk' => 'Slovak',
        'sk-SK' => 'Slovak (Slovakia)',
        'sl' => 'Slovenian',
        'sl-SI' => 'Slovenian (Slovenia)',
        'smn' => 'Inari Sami',
        'smn-FI' => 'Inari Sami (Finland)',
        'sn' => 'Shona',
        'sn-ZW' => 'Shona (Zimbabwe)',
        'so' => 'Somali',
        'so-DJ' => 'Somali (Djibouti)',
        'so-ET' => 'Somali (Ethiopia)',
        'so-KE' => 'Somali (Kenya)',
        'so-SO' => 'Somali (Somalia)',
        'sq' => 'Albanian',
        'sq-AL' => 'Albanian (Albania)',
        'sq-MK' => 'Albanian (North Macedonia)',
        'sq-XK' => 'Albanian (Kosovo)',
        'sr' => 'Serbian',
        'sr-Cyrl' => 'Serbian (Cyrillic)',
        'sr-Cyrl-BA' => 'Serbian (Cyrillic, Bosnia & Herzegovina)',
        'sr-Cyrl-ME' => 'Serbian (Cyrillic, Montenegro)',
        'sr-Cyrl-RS' => 'Serbian (Cyrillic, Serbia)',
        'sr-Cyrl-XK' => 'Serbian (Cyrillic, Kosovo)',
        'sr-Latn' => 'Serbian (Latin)',
        'sr-Latn-BA' => 'Serbian (Latin, Bosnia & Herzegovina)',
        'sr-Latn-ME' => 'Serbian (Latin, Montenegro)',
        'sr-Latn-RS' => 'Serbian (Latin, Serbia)',
        'sr-Latn-XK' => 'Serbian (Latin, Kosovo)',
        'sv' => 'Swedish',
        'sv-AX' => 'Swedish (Åland Islands)',
        'sv-FI' => 'Swedish (Finland)',
        'sv-SE' => 'Swedish (Sweden)',
        'sw' => 'Swahili',
        'sw-CD' => 'Swahili (Congo - Kinshasa)',
        'sw-KE' => 'Swahili (Kenya)',
        'sw-TZ' => 'Swahili (Tanzania)',
        'sw-UG' => 'Swahili (Uganda)',
        'ta' => 'Tamil',
        'ta-IN' => 'Tamil (India)',
        'ta-LK' => 'Tamil (Sri Lanka)',
        'ta-MY' => 'Tamil (Malaysia)',
        'ta-SG' => 'Tamil (Singapore)',
        'te' => 'Telugu',
        'te-IN' => 'Telugu (India)',
        'teo' => 'Teso',
        'teo-KE' => 'Teso (Kenya)',
        'teo-UG' => 'Teso (Uganda)',
        'tg' => 'Tajik',
        'tg-TJ' => 'Tajik (Tajikistan)',
        'th' => 'Thai',
        'th-TH' => 'Thai (Thailand)',
        'ti' => 'Tigrinya',
        'ti-ER' => 'Tigrinya (Eritrea)',
        'ti-ET' => 'Tigrinya (Ethiopia)',
        'tk' => 'Turkmen',
        'tk-TM' => 'Turkmen (Turkmenistan)',
        'to' => 'Tongan',
        'to-TO' => 'Tongan (Tonga)',
        'tr' => 'Turkish',
        'tr-CY' => 'Turkish (Cyprus)',
        'tr-TR' => 'Turkish (Turkey)',
        'tt' => 'Tatar',
        'tt-RU' => 'Tatar (Russia)',
        'twq' => 'Tasawaq',
        'twq-NE' => 'Tasawaq (Niger)',
        'tzm' => 'Central Atlas Tamazight',
        'tzm-MA' => 'Central Atlas Tamazight (Morocco)',
        'ug' => 'Uyghur',
        'ug-CN' => 'Uyghur (China)',
        'uk' => 'Ukrainian',
        'uk-UA' => 'Ukrainian (Ukraine)',
        'ur' => 'Urdu',
        'ur-IN' => 'Urdu (India)',
        'ur-PK' => 'Urdu (Pakistan)',
        'uz' => 'Uzbek',
        'uz-Arab' => 'Uzbek (Arabic)',
        'uz-Arab-AF' => 'Uzbek (Arabic, Afghanistan)',
        'uz-Cyrl' => 'Uzbek (Cyrillic)',
        'uz-Cyrl-UZ' => 'Uzbek (Cyrillic, Uzbekistan)',
        'uz-Latn' => 'Uzbek (Latin)',
        'uz-Latn-UZ' => 'Uzbek (Latin, Uzbekistan)',
        'vai' => 'Vai',
        'vai-Latn' => 'Vai (Latin)',
        'vai-Latn-LR' => 'Vai (Latin, Liberia)',
        'vai-Vaii' => 'Vai (Vai)',
        'vai-Vaii-LR' => 'Vai (Vai, Liberia)',
        'vi' => 'Vietnamese',
        'vi-VN' => 'Vietnamese (Vietnam)',
        'vun' => 'Vunjo',
        'vun-TZ' => 'Vunjo (Tanzania)',
        'wae' => 'Walser',
        'wae-CH' => 'Walser (Switzerland)',
        'wo' => 'Wolof',
        'wo-SN' => 'Wolof (Senegal)',
        'xh' => 'Xhosa',
        'xh-ZA' => 'Xhosa (South Africa)',
        'xog' => 'Soga',
        'xog-UG' => 'Soga (Uganda)',
        'yav' => 'Yangben',
        'yav-CM' => 'Yangben (Cameroon)',
        'yi' => 'Yiddish',
        'yi-001' => 'Yiddish (World)',
        'yo' => 'Yoruba',
        'yo-BJ' => 'Yoruba (Benin)',
        'yo-NG' => 'Yoruba (Nigeria)',
        'yue' => 'Cantonese',
        'yue-Hans' => 'Cantonese (Simplified)',
        'yue-Hans-CN' => 'Cantonese (Simplified, China)',
        'yue-Hant' => 'Cantonese (Traditional)',
        'yue-Hant-HK' => 'Cantonese (Traditional, Hong Kong SAR China)',
        'zgh' => 'Standard Moroccan Tamazight',
        'zgh-MA' => 'Standard Moroccan Tamazight (Morocco)',
        'zh' => 'Chinese',
        'zh-Hans' => 'Chinese (Simplified)',
        'zh-Hans-CN' => 'Chinese (Simplified, China)',
        'zh-Hans-HK' => 'Chinese (Simplified, Hong Kong SAR China)',
        'zh-Hans-MO' => 'Chinese (Simplified, Macao SAR China)',
        'zh-Hans-SG' => 'Chinese (Simplified, Singapore)',
        'zh-Hant' => 'Chinese (Traditional)',
        'zh-Hant-HK' => 'Chinese (Traditional, Hong Kong SAR China)',
        'zh-Hant-MO' => 'Chinese (Traditional, Macao SAR China)',
        'zh-Hant-TW' => 'Chinese (Traditional, Taiwan)',
        'zu' => 'Zulu',
        'zu-ZA' => 'Zulu (South Africa)',
    ],
];
