<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.M.y',
            'time' => 'H:mm',
            'datetime' => 'd.M.y, H:mm',
        ],
        'medium' => [
            'date' => 'd בMMM y',
            'time' => 'H:mm:ss',
            'datetime' => 'd בMMM y, H:mm:ss',
        ],
        'long' => [
            'date' => 'd בMMMM y',
            'time' => 'H:mm:ss z',
            'datetime' => 'd בMMMM y בשעה H:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d בMMMM y',
            'time' => 'H:mm:ss zzzz',
            'datetime' => 'EEEE, d בMMMM y בשעה H:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '‏#,##0.00 ¤;‏-#,##0.00 ¤',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'לפנה״צ',
    'pmName' => 'אחה״צ',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '‎-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '.',
        'groupingSeparator' => ',',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '‎-',
        'plusSign' => '‎+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '.',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ',',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => '‎CN¥‎ ',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳',
        ],
        'full' => [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12',
        ],
        'medium' => [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳',
        ],
        'full' => [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'short' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'medium' => [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת',
        ],
        'full' => [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'short' => [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳',
        ],
        'medium' => [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת',
        ],
        'full' => [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'אפריקאנס',
        'af-NA' => 'אפריקאנס (נמיביה)',
        'af-ZA' => 'אפריקאנס (דרום אפריקה)',
        'agq' => 'אע׳ם',
        'agq-CM' => 'אע׳ם (קמרון)',
        'ak' => 'אקאן',
        'ak-GH' => 'אקאן (גאנה)',
        'am' => 'אמהרית',
        'am-ET' => 'אמהרית (אתיופיה)',
        'ar' => 'ערבית',
        'ar-001' => 'ערבית (העולם)',
        'ar-AE' => 'ערבית (איחוד האמירויות הערביות)',
        'ar-BH' => 'ערבית (בחריין)',
        'ar-DJ' => 'ערבית (ג׳יבוטי)',
        'ar-DZ' => 'ערבית (אלג׳יריה)',
        'ar-EG' => 'ערבית (מצרים)',
        'ar-EH' => 'ערבית (סהרה המערבית)',
        'ar-ER' => 'ערבית (אריתריאה)',
        'ar-IL' => 'ערבית (ישראל)',
        'ar-IQ' => 'ערבית (עיראק)',
        'ar-JO' => 'ערבית (ירדן)',
        'ar-KM' => 'ערבית (קומורו)',
        'ar-KW' => 'ערבית (כווית)',
        'ar-LB' => 'ערבית (לבנון)',
        'ar-LY' => 'ערבית (לוב)',
        'ar-MA' => 'ערבית (מרוקו)',
        'ar-MR' => 'ערבית (מאוריטניה)',
        'ar-OM' => 'ערבית (עומאן)',
        'ar-PS' => 'ערבית (השטחים הפלסטיניים)',
        'ar-QA' => 'ערבית (קטאר)',
        'ar-SA' => 'ערבית (ערב הסעודית)',
        'ar-SD' => 'ערבית (סודן)',
        'ar-SO' => 'ערבית (סומליה)',
        'ar-SS' => 'ערבית (דרום סודן)',
        'ar-SY' => 'ערבית (סוריה)',
        'ar-TD' => 'ערבית (צ׳אד)',
        'ar-TN' => 'ערבית (תוניסיה)',
        'ar-YE' => 'ערבית (תימן)',
        'as' => 'אסאמית',
        'as-IN' => 'אסאמית (הודו)',
        'asa' => 'אסו',
        'asa-TZ' => 'אסו (טנזניה)',
        'ast' => 'אסטורית',
        'ast-ES' => 'אסטורית (ספרד)',
        'az' => 'אזרית',
        'az-Cyrl' => 'אזרית (קירילי)',
        'az-Cyrl-AZ' => 'אזרית (קירילי, אזרבייג׳ן)',
        'az-Latn' => 'אזרית (לטיני)',
        'az-Latn-AZ' => 'אזרית (לטיני, אזרבייג׳ן)',
        'bas' => 'בסאא',
        'bas-CM' => 'בסאא (קמרון)',
        'be' => 'בלארוסית',
        'be-BY' => 'בלארוסית (בלארוס)',
        'bem' => 'במבה',
        'bem-ZM' => 'במבה (זמביה)',
        'bez' => 'בנה',
        'bez-TZ' => 'בנה (טנזניה)',
        'bg' => 'בולגרית',
        'bg-BG' => 'בולגרית (בולגריה)',
        'bm' => 'במבארה',
        'bm-ML' => 'במבארה (מאלי)',
        'bn' => 'בנגלית',
        'bn-BD' => 'בנגלית (בנגלדש)',
        'bn-IN' => 'בנגלית (הודו)',
        'bo' => 'טיבטית',
        'bo-CN' => 'טיבטית (סין)',
        'bo-IN' => 'טיבטית (הודו)',
        'br' => 'ברטונית',
        'br-FR' => 'ברטונית (צרפת)',
        'brx' => 'בודו',
        'brx-IN' => 'בודו (הודו)',
        'bs' => 'בוסנית',
        'bs-Cyrl' => 'בוסנית (קירילי)',
        'bs-Cyrl-BA' => 'בוסנית (קירילי, בוסניה והרצגובינה)',
        'bs-Latn' => 'בוסנית (לטיני)',
        'bs-Latn-BA' => 'בוסנית (לטיני, בוסניה והרצגובינה)',
        'ca' => 'קטלאנית',
        'ca-AD' => 'קטלאנית (אנדורה)',
        'ca-ES' => 'קטלאנית (ספרד)',
        'ca-FR' => 'קטלאנית (צרפת)',
        'ca-IT' => 'קטלאנית (איטליה)',
        'ccp' => 'צ׳אקמה',
        'ccp-BD' => 'צ׳אקמה (בנגלדש)',
        'ccp-IN' => 'צ׳אקמה (הודו)',
        'ce' => 'צ׳צ׳נית',
        'ce-RU' => 'צ׳צ׳נית (רוסיה)',
        'ceb' => 'סבואנו',
        'ceb-PH' => 'סבואנו (הפיליפינים)',
        'cgg' => 'צ׳יגה',
        'cgg-UG' => 'צ׳יגה (אוגנדה)',
        'chr' => 'צ׳רוקי',
        'chr-US' => 'צ׳רוקי (ארצות הברית)',
        'ckb' => 'כורדית סוראנית',
        'ckb-IQ' => 'כורדית סוראנית (עיראק)',
        'ckb-IR' => 'כורדית סוראנית (איראן)',
        'cs' => 'צ׳כית',
        'cs-CZ' => 'צ׳כית (צ׳כיה)',
        'cy' => 'וולשית',
        'cy-GB' => 'וולשית (בריטניה)',
        'da' => 'דנית',
        'da-DK' => 'דנית (דנמרק)',
        'da-GL' => 'דנית (גרינלנד)',
        'dav' => 'טאיטה',
        'dav-KE' => 'טאיטה (קניה)',
        'de' => 'גרמנית',
        'de-AT' => 'גרמנית (אוסטריה)',
        'de-BE' => 'גרמנית (בלגיה)',
        'de-CH' => 'גרמנית (שווייץ)',
        'de-DE' => 'גרמנית (גרמניה)',
        'de-IT' => 'גרמנית (איטליה)',
        'de-LI' => 'גרמנית (ליכטנשטיין)',
        'de-LU' => 'גרמנית (לוקסמבורג)',
        'dje' => 'זארמה',
        'dje-NE' => 'זארמה (ניז׳ר)',
        'dsb' => 'סורבית תחתית',
        'dsb-DE' => 'סורבית תחתית (גרמניה)',
        'dua' => 'דואלה',
        'dua-CM' => 'דואלה (קמרון)',
        'dyo' => 'ג׳ולה פונית',
        'dyo-SN' => 'ג׳ולה פונית (סנגל)',
        'dz' => 'דזונקה',
        'dz-BT' => 'דזונקה (בהוטן)',
        'ebu' => 'אמבו',
        'ebu-KE' => 'אמבו (קניה)',
        'ee' => 'אווה',
        'ee-GH' => 'אווה (גאנה)',
        'ee-TG' => 'אווה (טוגו)',
        'el' => 'יוונית',
        'el-CY' => 'יוונית (קפריסין)',
        'el-GR' => 'יוונית (יוון)',
        'en' => 'אנגלית',
        'en-001' => 'אנגלית (העולם)',
        'en-150' => 'אנגלית (אירופה)',
        'en-AE' => 'אנגלית (איחוד האמירויות הערביות)',
        'en-AG' => 'אנגלית (אנטיגואה וברבודה)',
        'en-AI' => 'אנגלית (אנגווילה)',
        'en-AS' => 'אנגלית (סמואה האמריקנית)',
        'en-AT' => 'אנגלית (אוסטריה)',
        'en-AU' => 'אנגלית (אוסטרליה)',
        'en-BB' => 'אנגלית (ברבדוס)',
        'en-BE' => 'אנגלית (בלגיה)',
        'en-BI' => 'אנגלית (בורונדי)',
        'en-BM' => 'אנגלית (ברמודה)',
        'en-BS' => 'אנגלית (איי בהאמה)',
        'en-BW' => 'אנגלית (בוצוואנה)',
        'en-BZ' => 'אנגלית (בליז)',
        'en-CA' => 'אנגלית (קנדה)',
        'en-CC' => 'אנגלית (איי קוקוס [קילינג])',
        'en-CH' => 'אנגלית (שווייץ)',
        'en-CK' => 'אנגלית (איי קוק)',
        'en-CM' => 'אנגלית (קמרון)',
        'en-CX' => 'אנגלית (אי חג המולד)',
        'en-CY' => 'אנגלית (קפריסין)',
        'en-DE' => 'אנגלית (גרמניה)',
        'en-DG' => 'אנגלית (דייגו גרסיה)',
        'en-DK' => 'אנגלית (דנמרק)',
        'en-DM' => 'אנגלית (דומיניקה)',
        'en-ER' => 'אנגלית (אריתריאה)',
        'en-FI' => 'אנגלית (פינלנד)',
        'en-FJ' => 'אנגלית (פיג׳י)',
        'en-FK' => 'אנגלית (איי פוקלנד)',
        'en-FM' => 'אנגלית (מיקרונזיה)',
        'en-GB' => 'אנגלית (בריטניה)',
        'en-GD' => 'אנגלית (גרנדה)',
        'en-GG' => 'אנגלית (גרנזי)',
        'en-GH' => 'אנגלית (גאנה)',
        'en-GI' => 'אנגלית (גיברלטר)',
        'en-GM' => 'אנגלית (גמביה)',
        'en-GU' => 'אנגלית (גואם)',
        'en-GY' => 'אנגלית (גיאנה)',
        'en-HK' => 'אנגלית (הונג קונג [אזור מנהלי מיוחד של סין])',
        'en-IE' => 'אנגלית (אירלנד)',
        'en-IL' => 'אנגלית (ישראל)',
        'en-IM' => 'אנגלית (האי מאן)',
        'en-IN' => 'אנגלית (הודו)',
        'en-IO' => 'אנגלית (הטריטוריה הבריטית באוקיינוס ההודי)',
        'en-JE' => 'אנגלית (ג׳רזי)',
        'en-JM' => 'אנגלית (ג׳מייקה)',
        'en-KE' => 'אנגלית (קניה)',
        'en-KI' => 'אנגלית (קיריבאטי)',
        'en-KN' => 'אנגלית (סנט קיטס ונוויס)',
        'en-KY' => 'אנגלית (איי קיימן)',
        'en-LC' => 'אנגלית (סנט לוסיה)',
        'en-LR' => 'אנגלית (ליבריה)',
        'en-LS' => 'אנגלית (לסוטו)',
        'en-MG' => 'אנגלית (מדגסקר)',
        'en-MH' => 'אנגלית (איי מרשל)',
        'en-MO' => 'אנגלית (מקאו [אזור מנהלי מיוחד של סין])',
        'en-MP' => 'אנגלית (איי מריאנה הצפוניים)',
        'en-MS' => 'אנגלית (מונסראט)',
        'en-MT' => 'אנגלית (מלטה)',
        'en-MU' => 'אנגלית (מאוריציוס)',
        'en-MW' => 'אנגלית (מלאווי)',
        'en-MY' => 'אנגלית (מלזיה)',
        'en-NA' => 'אנגלית (נמיביה)',
        'en-NF' => 'אנגלית (האי נורפוק)',
        'en-NG' => 'אנגלית (ניגריה)',
        'en-NL' => 'אנגלית (הולנד)',
        'en-NR' => 'אנגלית (נאורו)',
        'en-NU' => 'אנגלית (ניווה)',
        'en-NZ' => 'אנגלית (ניו זילנד)',
        'en-PG' => 'אנגלית (פפואה גינאה החדשה)',
        'en-PH' => 'אנגלית (הפיליפינים)',
        'en-PK' => 'אנגלית (פקיסטן)',
        'en-PN' => 'אנגלית (איי פיטקרן)',
        'en-PR' => 'אנגלית (פוארטו ריקו)',
        'en-PW' => 'אנגלית (פלאו)',
        'en-RW' => 'אנגלית (רואנדה)',
        'en-SB' => 'אנגלית (איי שלמה)',
        'en-SC' => 'אנגלית (איי סיישל)',
        'en-SD' => 'אנגלית (סודן)',
        'en-SE' => 'אנגלית (שוודיה)',
        'en-SG' => 'אנגלית (סינגפור)',
        'en-SH' => 'אנגלית (סנט הלנה)',
        'en-SI' => 'אנגלית (סלובניה)',
        'en-SL' => 'אנגלית (סיירה לאונה)',
        'en-SS' => 'אנגלית (דרום סודן)',
        'en-SX' => 'אנגלית (סנט מארטן)',
        'en-SZ' => 'אנגלית (אסוואטיני)',
        'en-TC' => 'אנגלית (איי טרקס וקייקוס)',
        'en-TK' => 'אנגלית (טוקלאו)',
        'en-TO' => 'אנגלית (טונגה)',
        'en-TT' => 'אנגלית (טרינידד וטובגו)',
        'en-TV' => 'אנגלית (טובאלו)',
        'en-TZ' => 'אנגלית (טנזניה)',
        'en-UG' => 'אנגלית (אוגנדה)',
        'en-UM' => 'אנגלית (האיים המרוחקים הקטנים של ארה״ב)',
        'en-US' => 'אנגלית (ארצות הברית)',
        'en-US-POSIX' => 'אנגלית (ארצות הברית, מחשב)',
        'en-VC' => 'אנגלית (סנט וינסנט והגרנדינים)',
        'en-VG' => 'אנגלית (איי הבתולה הבריטיים)',
        'en-VI' => 'אנגלית (איי הבתולה של ארצות הברית)',
        'en-VU' => 'אנגלית (ונואטו)',
        'en-WS' => 'אנגלית (סמואה)',
        'en-ZA' => 'אנגלית (דרום אפריקה)',
        'en-ZM' => 'אנגלית (זמביה)',
        'en-ZW' => 'אנגלית (זימבבואה)',
        'eo' => 'אספרנטו',
        'eo-001' => 'אספרנטו (העולם)',
        'es' => 'ספרדית',
        'es-419' => 'ספרדית (אמריקה הלטינית)',
        'es-AR' => 'ספרדית (ארגנטינה)',
        'es-BO' => 'ספרדית (בוליביה)',
        'es-BR' => 'ספרדית (ברזיל)',
        'es-BZ' => 'ספרדית (בליז)',
        'es-CL' => 'ספרדית (צ׳ילה)',
        'es-CO' => 'ספרדית (קולומביה)',
        'es-CR' => 'ספרדית (קוסטה ריקה)',
        'es-CU' => 'ספרדית (קובה)',
        'es-DO' => 'ספרדית (הרפובליקה הדומיניקנית)',
        'es-EA' => 'ספרדית (סאוטה ומלייה)',
        'es-EC' => 'ספרדית (אקוודור)',
        'es-ES' => 'ספרדית (ספרד)',
        'es-GQ' => 'ספרדית (גינאה המשוונית)',
        'es-GT' => 'ספרדית (גואטמלה)',
        'es-HN' => 'ספרדית (הונדורס)',
        'es-IC' => 'ספרדית (האיים הקנריים)',
        'es-MX' => 'ספרדית (מקסיקו)',
        'es-NI' => 'ספרדית (ניקרגואה)',
        'es-PA' => 'ספרדית (פנמה)',
        'es-PE' => 'ספרדית (פרו)',
        'es-PH' => 'ספרדית (הפיליפינים)',
        'es-PR' => 'ספרדית (פוארטו ריקו)',
        'es-PY' => 'ספרדית (פרגוואי)',
        'es-SV' => 'ספרדית (אל סלבדור)',
        'es-US' => 'ספרדית (ארצות הברית)',
        'es-UY' => 'ספרדית (אורוגוואי)',
        'es-VE' => 'ספרדית (ונצואלה)',
        'et' => 'אסטונית',
        'et-EE' => 'אסטונית (אסטוניה)',
        'eu' => 'בסקית',
        'eu-ES' => 'בסקית (ספרד)',
        'ewo' => 'אוונדו',
        'ewo-CM' => 'אוונדו (קמרון)',
        'fa' => 'פרסית',
        'fa-AF' => 'פרסית (אפגניסטן)',
        'fa-IR' => 'פרסית (איראן)',
        'ff' => 'פולה',
        'ff-Latn' => 'פולה (לטיני)',
        'ff-Latn-BF' => 'פולה (לטיני, בורקינה פאסו)',
        'ff-Latn-CM' => 'פולה (לטיני, קמרון)',
        'ff-Latn-GH' => 'פולה (לטיני, גאנה)',
        'ff-Latn-GM' => 'פולה (לטיני, גמביה)',
        'ff-Latn-GN' => 'פולה (לטיני, גינאה)',
        'ff-Latn-GW' => 'פולה (לטיני, גינאה-ביסאו)',
        'ff-Latn-LR' => 'פולה (לטיני, ליבריה)',
        'ff-Latn-MR' => 'פולה (לטיני, מאוריטניה)',
        'ff-Latn-NE' => 'פולה (לטיני, ניז׳ר)',
        'ff-Latn-NG' => 'פולה (לטיני, ניגריה)',
        'ff-Latn-SL' => 'פולה (לטיני, סיירה לאונה)',
        'ff-Latn-SN' => 'פולה (לטיני, סנגל)',
        'fi' => 'פינית',
        'fi-FI' => 'פינית (פינלנד)',
        'fil' => 'פיליפינית',
        'fil-PH' => 'פיליפינית (הפיליפינים)',
        'fo' => 'פארואזית',
        'fo-DK' => 'פארואזית (דנמרק)',
        'fo-FO' => 'פארואזית (איי פארו)',
        'fr' => 'צרפתית',
        'fr-BE' => 'צרפתית (בלגיה)',
        'fr-BF' => 'צרפתית (בורקינה פאסו)',
        'fr-BI' => 'צרפתית (בורונדי)',
        'fr-BJ' => 'צרפתית (בנין)',
        'fr-BL' => 'צרפתית (סנט ברתולומיאו)',
        'fr-CA' => 'צרפתית (קנדה)',
        'fr-CD' => 'צרפתית (קונגו - קינשאסה)',
        'fr-CF' => 'צרפתית (הרפובליקה המרכז-אפריקאית)',
        'fr-CG' => 'צרפתית (קונגו - ברזאויל)',
        'fr-CH' => 'צרפתית (שווייץ)',
        'fr-CI' => 'צרפתית (חוף השנהב)',
        'fr-CM' => 'צרפתית (קמרון)',
        'fr-DJ' => 'צרפתית (ג׳יבוטי)',
        'fr-DZ' => 'צרפתית (אלג׳יריה)',
        'fr-FR' => 'צרפתית (צרפת)',
        'fr-GA' => 'צרפתית (גבון)',
        'fr-GF' => 'צרפתית (גיאנה הצרפתית)',
        'fr-GN' => 'צרפתית (גינאה)',
        'fr-GP' => 'צרפתית (גוואדלופ)',
        'fr-GQ' => 'צרפתית (גינאה המשוונית)',
        'fr-HT' => 'צרפתית (האיטי)',
        'fr-KM' => 'צרפתית (קומורו)',
        'fr-LU' => 'צרפתית (לוקסמבורג)',
        'fr-MA' => 'צרפתית (מרוקו)',
        'fr-MC' => 'צרפתית (מונקו)',
        'fr-MF' => 'צרפתית (סן מרטן)',
        'fr-MG' => 'צרפתית (מדגסקר)',
        'fr-ML' => 'צרפתית (מאלי)',
        'fr-MQ' => 'צרפתית (מרטיניק)',
        'fr-MR' => 'צרפתית (מאוריטניה)',
        'fr-MU' => 'צרפתית (מאוריציוס)',
        'fr-NC' => 'צרפתית (קלדוניה החדשה)',
        'fr-NE' => 'צרפתית (ניז׳ר)',
        'fr-PF' => 'צרפתית (פולינזיה הצרפתית)',
        'fr-PM' => 'צרפתית (סנט פייר ומיקלון)',
        'fr-RE' => 'צרפתית (ראוניון)',
        'fr-RW' => 'צרפתית (רואנדה)',
        'fr-SC' => 'צרפתית (איי סיישל)',
        'fr-SN' => 'צרפתית (סנגל)',
        'fr-SY' => 'צרפתית (סוריה)',
        'fr-TD' => 'צרפתית (צ׳אד)',
        'fr-TG' => 'צרפתית (טוגו)',
        'fr-TN' => 'צרפתית (תוניסיה)',
        'fr-VU' => 'צרפתית (ונואטו)',
        'fr-WF' => 'צרפתית (איי ווליס ופוטונה)',
        'fr-YT' => 'צרפתית (מאיוט)',
        'fur' => 'פריולית',
        'fur-IT' => 'פריולית (איטליה)',
        'fy' => 'פריזית מערבית',
        'fy-NL' => 'פריזית מערבית (הולנד)',
        'ga' => 'אירית',
        'ga-IE' => 'אירית (אירלנד)',
        'gd' => 'גאלית סקוטית',
        'gd-GB' => 'גאלית סקוטית (בריטניה)',
        'gl' => 'גליציאנית',
        'gl-ES' => 'גליציאנית (ספרד)',
        'gsw' => 'גרמנית שוויצרית',
        'gsw-CH' => 'גרמנית שוויצרית (שווייץ)',
        'gsw-FR' => 'גרמנית שוויצרית (צרפת)',
        'gsw-LI' => 'גרמנית שוויצרית (ליכטנשטיין)',
        'gu' => 'גוג׳ארטי',
        'gu-IN' => 'גוג׳ארטי (הודו)',
        'guz' => 'גוסי',
        'guz-KE' => 'גוסי (קניה)',
        'gv' => 'מאנית',
        'gv-IM' => 'מאנית (האי מאן)',
        'ha' => 'האוסה',
        'ha-GH' => 'האוסה (גאנה)',
        'ha-NE' => 'האוסה (ניז׳ר)',
        'ha-NG' => 'האוסה (ניגריה)',
        'haw' => 'הוואית',
        'haw-US' => 'הוואית (ארצות הברית)',
        'he' => 'עברית',
        'he-IL' => 'עברית (ישראל)',
        'hi' => 'הינדי',
        'hi-IN' => 'הינדי (הודו)',
        'hr' => 'קרואטית',
        'hr-BA' => 'קרואטית (בוסניה והרצגובינה)',
        'hr-HR' => 'קרואטית (קרואטיה)',
        'hsb' => 'סורבית גבוהה',
        'hsb-DE' => 'סורבית גבוהה (גרמניה)',
        'hu' => 'הונגרית',
        'hu-HU' => 'הונגרית (הונגריה)',
        'hy' => 'ארמנית',
        'hy-AM' => 'ארמנית (ארמניה)',
        'ia' => '‏אינטרלינגואה',
        'ia-001' => '‏אינטרלינגואה (העולם)',
        'id' => 'אינדונזית',
        'id-ID' => 'אינדונזית (אינדונזיה)',
        'ig' => 'איגבו',
        'ig-NG' => 'איגבו (ניגריה)',
        'ii' => 'סצ׳ואן יי',
        'ii-CN' => 'סצ׳ואן יי (סין)',
        'is' => 'איסלנדית',
        'is-IS' => 'איסלנדית (איסלנד)',
        'it' => 'איטלקית',
        'it-CH' => 'איטלקית (שווייץ)',
        'it-IT' => 'איטלקית (איטליה)',
        'it-SM' => 'איטלקית (סן מרינו)',
        'it-VA' => 'איטלקית (הוותיקן)',
        'ja' => 'יפנית',
        'ja-JP' => 'יפנית (יפן)',
        'jgo' => 'נגומבה',
        'jgo-CM' => 'נגומבה (קמרון)',
        'jmc' => 'מאקאמה',
        'jmc-TZ' => 'מאקאמה (טנזניה)',
        'jv' => 'יאוואית',
        'jv-ID' => 'יאוואית (אינדונזיה)',
        'ka' => 'גאורגית',
        'ka-GE' => 'גאורגית (גאורגיה)',
        'kab' => 'קבילה',
        'kab-DZ' => 'קבילה (אלג׳יריה)',
        'kam' => 'קמבה',
        'kam-KE' => 'קמבה (קניה)',
        'kde' => 'מקונדה',
        'kde-TZ' => 'מקונדה (טנזניה)',
        'kea' => 'קאבוורדיאנו',
        'kea-CV' => 'קאבוורדיאנו (כף ורדה)',
        'khq' => 'קוירה צ׳יני',
        'khq-ML' => 'קוירה צ׳יני (מאלי)',
        'ki' => 'קיקויו',
        'ki-KE' => 'קיקויו (קניה)',
        'kk' => 'קזחית',
        'kk-KZ' => 'קזחית (קזחסטן)',
        'kkj' => 'קאקו',
        'kkj-CM' => 'קאקו (קמרון)',
        'kl' => 'גרינלנדית',
        'kl-GL' => 'גרינלנדית (גרינלנד)',
        'kln' => 'קלנג׳ין',
        'kln-KE' => 'קלנג׳ין (קניה)',
        'km' => 'חמרית',
        'km-KH' => 'חמרית (קמבודיה)',
        'kn' => 'קנאדה',
        'kn-IN' => 'קנאדה (הודו)',
        'ko' => 'קוריאנית',
        'ko-KP' => 'קוריאנית (קוריאה הצפונית)',
        'ko-KR' => 'קוריאנית (קוריאה הדרומית)',
        'kok' => 'קונקאני',
        'kok-IN' => 'קונקאני (הודו)',
        'ks' => 'קשמירית',
        'ks-IN' => 'קשמירית (הודו)',
        'ksb' => 'שמבאלה',
        'ksb-TZ' => 'שמבאלה (טנזניה)',
        'ksf' => 'באפיה',
        'ksf-CM' => 'באפיה (קמרון)',
        'ksh' => 'קולוניאן',
        'ksh-DE' => 'קולוניאן (גרמניה)',
        'ku' => 'כורדית',
        'ku-TR' => 'כורדית (טורקיה)',
        'kw' => 'קורנית',
        'kw-GB' => 'קורנית (בריטניה)',
        'ky' => 'קירגיזית',
        'ky-KG' => 'קירגיזית (קירגיזסטן)',
        'lag' => 'לאנגי',
        'lag-TZ' => 'לאנגי (טנזניה)',
        'lb' => 'לוקסמבורגית',
        'lb-LU' => 'לוקסמבורגית (לוקסמבורג)',
        'lg' => 'גאנדה',
        'lg-UG' => 'גאנדה (אוגנדה)',
        'lkt' => 'לקוטה',
        'lkt-US' => 'לקוטה (ארצות הברית)',
        'ln' => 'לינגלה',
        'ln-AO' => 'לינגלה (אנגולה)',
        'ln-CD' => 'לינגלה (קונגו - קינשאסה)',
        'ln-CF' => 'לינגלה (הרפובליקה המרכז-אפריקאית)',
        'ln-CG' => 'לינגלה (קונגו - ברזאויל)',
        'lo' => 'לאו',
        'lo-LA' => 'לאו (לאוס)',
        'lrc' => 'לורית צפונית',
        'lrc-IQ' => 'לורית צפונית (עיראק)',
        'lrc-IR' => 'לורית צפונית (איראן)',
        'lt' => 'ליטאית',
        'lt-LT' => 'ליטאית (ליטא)',
        'lu' => 'לובה-קטנגה',
        'lu-CD' => 'לובה-קטנגה (קונגו - קינשאסה)',
        'luo' => 'לואו',
        'luo-KE' => 'לואו (קניה)',
        'luy' => 'לויה',
        'luy-KE' => 'לויה (קניה)',
        'lv' => 'לטבית',
        'lv-LV' => 'לטבית (לטביה)',
        'mas' => 'מסאית',
        'mas-KE' => 'מסאית (קניה)',
        'mas-TZ' => 'מסאית (טנזניה)',
        'mer' => 'מרו',
        'mer-KE' => 'מרו (קניה)',
        'mfe' => 'קריאולית מאוריציאנית',
        'mfe-MU' => 'קריאולית מאוריציאנית (מאוריציוס)',
        'mg' => 'מלגשית',
        'mg-MG' => 'מלגשית (מדגסקר)',
        'mgh' => 'מאקוואה מטו',
        'mgh-MZ' => 'מאקוואה מטו (מוזמביק)',
        'mgo' => 'מטא',
        'mgo-CM' => 'מטא (קמרון)',
        'mi' => 'מאורית',
        'mi-NZ' => 'מאורית (ניו זילנד)',
        'mk' => 'מקדונית',
        'mk-MK' => 'מקדונית (מקדוניה הצפונית)',
        'ml' => 'מליאלאם',
        'ml-IN' => 'מליאלאם (הודו)',
        'mn' => 'מונגולית',
        'mn-MN' => 'מונגולית (מונגוליה)',
        'mr' => 'מראטהי',
        'mr-IN' => 'מראטהי (הודו)',
        'ms' => 'מלאית',
        'ms-BN' => 'מלאית (ברוניי)',
        'ms-MY' => 'מלאית (מלזיה)',
        'ms-SG' => 'מלאית (סינגפור)',
        'mt' => 'מלטית',
        'mt-MT' => 'מלטית (מלטה)',
        'mua' => 'מונדאנג',
        'mua-CM' => 'מונדאנג (קמרון)',
        'my' => 'בורמזית',
        'my-MM' => 'בורמזית (מיאנמר [בורמה])',
        'mzn' => 'מאזאנדראני',
        'mzn-IR' => 'מאזאנדראני (איראן)',
        'naq' => 'נאמה',
        'naq-NA' => 'נאמה (נמיביה)',
        'nb' => 'נורווגית ספרותית',
        'nb-NO' => 'נורווגית ספרותית (נורווגיה)',
        'nb-SJ' => 'נורווגית ספרותית (סבאלברד ויאן מאיין)',
        'nd' => 'נדבלה צפונית',
        'nd-ZW' => 'נדבלה צפונית (זימבבואה)',
        'nds' => 'גרמנית תחתית',
        'nds-DE' => 'גרמנית תחתית (גרמניה)',
        'nds-NL' => 'גרמנית תחתית (הולנד)',
        'ne' => 'נפאלית',
        'ne-IN' => 'נפאלית (הודו)',
        'ne-NP' => 'נפאלית (נפאל)',
        'nl' => 'הולנדית',
        'nl-AW' => 'הולנדית (ארובה)',
        'nl-BE' => 'הולנדית (בלגיה)',
        'nl-BQ' => 'הולנדית (האיים הקריביים ההולנדיים)',
        'nl-CW' => 'הולנדית (קוראסאו)',
        'nl-NL' => 'הולנדית (הולנד)',
        'nl-SR' => 'הולנדית (סורינאם)',
        'nl-SX' => 'הולנדית (סנט מארטן)',
        'nmg' => 'קוואסיו',
        'nmg-CM' => 'קוואסיו (קמרון)',
        'nn' => 'נורווגית חדשה',
        'nn-NO' => 'נורווגית חדשה (נורווגיה)',
        'nnh' => 'נגיאמבון',
        'nnh-CM' => 'נגיאמבון (קמרון)',
        'nus' => 'נואר',
        'nus-SS' => 'נואר (דרום סודן)',
        'nyn' => 'ניאנקולה',
        'nyn-UG' => 'ניאנקולה (אוגנדה)',
        'om' => 'אורומו',
        'om-ET' => 'אורומו (אתיופיה)',
        'om-KE' => 'אורומו (קניה)',
        'or' => 'אורייה',
        'or-IN' => 'אורייה (הודו)',
        'os' => 'אוסטית',
        'os-GE' => 'אוסטית (גאורגיה)',
        'os-RU' => 'אוסטית (רוסיה)',
        'pa' => 'פנג׳אבי',
        'pa-Arab' => 'פנג׳אבי (ערבי)',
        'pa-Arab-PK' => 'פנג׳אבי (ערבי, פקיסטן)',
        'pa-Guru' => 'פנג׳אבי (גורמוקי)',
        'pa-Guru-IN' => 'פנג׳אבי (גורמוקי, הודו)',
        'pl' => 'פולנית',
        'pl-PL' => 'פולנית (פולין)',
        'ps' => 'פאשטו',
        'ps-AF' => 'פאשטו (אפגניסטן)',
        'ps-PK' => 'פאשטו (פקיסטן)',
        'pt' => 'פורטוגזית',
        'pt-AO' => 'פורטוגזית (אנגולה)',
        'pt-BR' => 'פורטוגזית (ברזיל)',
        'pt-CH' => 'פורטוגזית (שווייץ)',
        'pt-CV' => 'פורטוגזית (כף ורדה)',
        'pt-GQ' => 'פורטוגזית (גינאה המשוונית)',
        'pt-GW' => 'פורטוגזית (גינאה-ביסאו)',
        'pt-LU' => 'פורטוגזית (לוקסמבורג)',
        'pt-MO' => 'פורטוגזית (מקאו [אזור מנהלי מיוחד של סין])',
        'pt-MZ' => 'פורטוגזית (מוזמביק)',
        'pt-PT' => 'פורטוגזית (פורטוגל)',
        'pt-ST' => 'פורטוגזית (סאו טומה ופרינסיפה)',
        'pt-TL' => 'פורטוגזית (טימור-לסטה)',
        'qu' => 'קצ׳ואה',
        'qu-BO' => 'קצ׳ואה (בוליביה)',
        'qu-EC' => 'קצ׳ואה (אקוודור)',
        'qu-PE' => 'קצ׳ואה (פרו)',
        'rm' => 'רומאנש',
        'rm-CH' => 'רומאנש (שווייץ)',
        'rn' => 'קירונדי',
        'rn-BI' => 'קירונדי (בורונדי)',
        'ro' => 'רומנית',
        'ro-MD' => 'רומנית (מולדובה)',
        'ro-RO' => 'רומנית (רומניה)',
        'rof' => 'רומבו',
        'rof-TZ' => 'רומבו (טנזניה)',
        'ru' => 'רוסית',
        'ru-BY' => 'רוסית (בלארוס)',
        'ru-KG' => 'רוסית (קירגיזסטן)',
        'ru-KZ' => 'רוסית (קזחסטן)',
        'ru-MD' => 'רוסית (מולדובה)',
        'ru-RU' => 'רוסית (רוסיה)',
        'ru-UA' => 'רוסית (אוקראינה)',
        'rw' => 'קנירואנדית',
        'rw-RW' => 'קנירואנדית (רואנדה)',
        'rwk' => 'ראווה',
        'rwk-TZ' => 'ראווה (טנזניה)',
        'sah' => 'סאחה',
        'sah-RU' => 'סאחה (רוסיה)',
        'saq' => 'סמבורו',
        'saq-KE' => 'סמבורו (קניה)',
        'sbp' => 'סאנגו',
        'sbp-TZ' => 'סאנגו (טנזניה)',
        'sd' => 'סינדהית',
        'sd-PK' => 'סינדהית (פקיסטן)',
        'se' => 'סמי צפונית',
        'se-FI' => 'סמי צפונית (פינלנד)',
        'se-NO' => 'סמי צפונית (נורווגיה)',
        'se-SE' => 'סמי צפונית (שוודיה)',
        'seh' => 'סנה',
        'seh-MZ' => 'סנה (מוזמביק)',
        'ses' => 'קויראבורו סני',
        'ses-ML' => 'קויראבורו סני (מאלי)',
        'sg' => 'סנגו',
        'sg-CF' => 'סנגו (הרפובליקה המרכז-אפריקאית)',
        'shi' => 'שילה',
        'shi-Latn' => 'שילה (לטיני)',
        'shi-Latn-MA' => 'שילה (לטיני, מרוקו)',
        'shi-Tfng' => 'שילה (Tfng)',
        'shi-Tfng-MA' => 'שילה (Tfng, מרוקו)',
        'si' => 'סינהלה',
        'si-LK' => 'סינהלה (סרי לנקה)',
        'sk' => 'סלובקית',
        'sk-SK' => 'סלובקית (סלובקיה)',
        'sl' => 'סלובנית',
        'sl-SI' => 'סלובנית (סלובניה)',
        'smn' => 'אינארי סאמי',
        'smn-FI' => 'אינארי סאמי (פינלנד)',
        'sn' => 'שונה',
        'sn-ZW' => 'שונה (זימבבואה)',
        'so' => 'סומלית',
        'so-DJ' => 'סומלית (ג׳יבוטי)',
        'so-ET' => 'סומלית (אתיופיה)',
        'so-KE' => 'סומלית (קניה)',
        'so-SO' => 'סומלית (סומליה)',
        'sq' => 'אלבנית',
        'sq-AL' => 'אלבנית (אלבניה)',
        'sq-MK' => 'אלבנית (מקדוניה הצפונית)',
        'sq-XK' => 'אלבנית (קוסובו)',
        'sr' => 'סרבית',
        'sr-Cyrl' => 'סרבית (קירילי)',
        'sr-Cyrl-BA' => 'סרבית (קירילי, בוסניה והרצגובינה)',
        'sr-Cyrl-ME' => 'סרבית (קירילי, מונטנגרו)',
        'sr-Cyrl-RS' => 'סרבית (קירילי, סרביה)',
        'sr-Cyrl-XK' => 'סרבית (קירילי, קוסובו)',
        'sr-Latn' => 'סרבית (לטיני)',
        'sr-Latn-BA' => 'סרבית (לטיני, בוסניה והרצגובינה)',
        'sr-Latn-ME' => 'סרבית (לטיני, מונטנגרו)',
        'sr-Latn-RS' => 'סרבית (לטיני, סרביה)',
        'sr-Latn-XK' => 'סרבית (לטיני, קוסובו)',
        'sv' => 'שוודית',
        'sv-AX' => 'שוודית (איי אולנד)',
        'sv-FI' => 'שוודית (פינלנד)',
        'sv-SE' => 'שוודית (שוודיה)',
        'sw' => 'סווהילי',
        'sw-CD' => 'סווהילי (קונגו - קינשאסה)',
        'sw-KE' => 'סווהילי (קניה)',
        'sw-TZ' => 'סווהילי (טנזניה)',
        'sw-UG' => 'סווהילי (אוגנדה)',
        'ta' => 'טמילית',
        'ta-IN' => 'טמילית (הודו)',
        'ta-LK' => 'טמילית (סרי לנקה)',
        'ta-MY' => 'טמילית (מלזיה)',
        'ta-SG' => 'טמילית (סינגפור)',
        'te' => 'טלוגו',
        'te-IN' => 'טלוגו (הודו)',
        'teo' => 'טסו',
        'teo-KE' => 'טסו (קניה)',
        'teo-UG' => 'טסו (אוגנדה)',
        'tg' => 'טג׳יקית',
        'tg-TJ' => 'טג׳יקית (טג׳יקיסטן)',
        'th' => 'תאית',
        'th-TH' => 'תאית (תאילנד)',
        'ti' => 'תיגרינית',
        'ti-ER' => 'תיגרינית (אריתריאה)',
        'ti-ET' => 'תיגרינית (אתיופיה)',
        'tk' => 'טורקמנית',
        'tk-TM' => 'טורקמנית (טורקמניסטן)',
        'to' => 'טונגאית',
        'to-TO' => 'טונגאית (טונגה)',
        'tr' => 'טורקית',
        'tr-CY' => 'טורקית (קפריסין)',
        'tr-TR' => 'טורקית (טורקיה)',
        'tt' => 'טטרית',
        'tt-RU' => 'טטרית (רוסיה)',
        'twq' => 'טסוואק',
        'twq-NE' => 'טסוואק (ניז׳ר)',
        'tzm' => 'תמאזיגת של מרכז מרוקו',
        'tzm-MA' => 'תמאזיגת של מרכז מרוקו (מרוקו)',
        'ug' => 'אויגור',
        'ug-CN' => 'אויגור (סין)',
        'uk' => 'אוקראינית',
        'uk-UA' => 'אוקראינית (אוקראינה)',
        'ur' => 'אורדו',
        'ur-IN' => 'אורדו (הודו)',
        'ur-PK' => 'אורדו (פקיסטן)',
        'uz' => 'אוזבקית',
        'uz-Arab' => 'אוזבקית (ערבי)',
        'uz-Arab-AF' => 'אוזבקית (ערבי, אפגניסטן)',
        'uz-Cyrl' => 'אוזבקית (קירילי)',
        'uz-Cyrl-UZ' => 'אוזבקית (קירילי, אוזבקיסטן)',
        'uz-Latn' => 'אוזבקית (לטיני)',
        'uz-Latn-UZ' => 'אוזבקית (לטיני, אוזבקיסטן)',
        'vai' => 'וואי',
        'vai-Latn' => 'וואי (לטיני)',
        'vai-Latn-LR' => 'וואי (לטיני, ליבריה)',
        'vai-Vaii' => 'וואי (Vaii)',
        'vai-Vaii-LR' => 'וואי (Vaii, ליבריה)',
        'vi' => 'ויאטנמית',
        'vi-VN' => 'ויאטנמית (וייטנאם)',
        'vun' => 'וונג׳ו',
        'vun-TZ' => 'וונג׳ו (טנזניה)',
        'wae' => 'וואלסר',
        'wae-CH' => 'וואלסר (שווייץ)',
        'wo' => 'וולוף',
        'wo-SN' => 'וולוף (סנגל)',
        'xh' => 'קוסה',
        'xh-ZA' => 'קוסה (דרום אפריקה)',
        'xog' => 'סוגה',
        'xog-UG' => 'סוגה (אוגנדה)',
        'yav' => 'יאנגבן',
        'yav-CM' => 'יאנגבן (קמרון)',
        'yi' => 'יידיש',
        'yi-001' => 'יידיש (העולם)',
        'yo' => 'יורובה',
        'yo-BJ' => 'יורובה (בנין)',
        'yo-NG' => 'יורובה (ניגריה)',
        'yue' => 'קנטונזית',
        'yue-Hans' => 'קנטונזית (פשוט)',
        'yue-Hans-CN' => 'קנטונזית (פשוט, סין)',
        'yue-Hant' => 'קנטונזית (מסורתי)',
        'yue-Hant-HK' => 'קנטונזית (מסורתי, הונג קונג [אזור מנהלי מיוחד של סין])',
        'zgh' => 'תמזיע׳ת מרוקאית תקנית',
        'zgh-MA' => 'תמזיע׳ת מרוקאית תקנית (מרוקו)',
        'zh' => 'סינית',
        'zh-Hans' => 'סינית (פשוט)',
        'zh-Hans-CN' => 'סינית (פשוט, סין)',
        'zh-Hans-HK' => 'סינית (פשוט, הונג קונג [אזור מנהלי מיוחד של סין])',
        'zh-Hans-MO' => 'סינית (פשוט, מקאו [אזור מנהלי מיוחד של סין])',
        'zh-Hans-SG' => 'סינית (פשוט, סינגפור)',
        'zh-Hant' => 'סינית (מסורתי)',
        'zh-Hant-HK' => 'סינית (מסורתי, הונג קונג [אזור מנהלי מיוחד של סין])',
        'zh-Hant-MO' => 'סינית (מסורתי, מקאו [אזור מנהלי מיוחד של סין])',
        'zh-Hant-TW' => 'סינית (מסורתי, טייוואן)',
        'zu' => 'זולו',
        'zu-ZA' => 'זולו (דרום אפריקה)',
    ],
];
