<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'y. MM. dd.',
            'time' => 'H:mm',
            'datetime' => 'y. MM. dd. H:mm',
        ],
        'medium' => [
            'date' => 'y. MMM d.',
            'time' => 'H:mm:ss',
            'datetime' => 'y. MMM d. H:mm:ss',
        ],
        'long' => [
            'date' => 'y. MMMM d.',
            'time' => 'H:mm:ss z',
            'datetime' => 'y. MMMM d. H:mm:ss z',
        ],
        'full' => [
            'date' => 'y. MMMM d., EEEE',
            'time' => 'H:mm:ss zzzz',
            'datetime' => 'y. MMMM d., EEEE H:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'de.',
    'pmName' => 'du.',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'AUD ',
        'BRL' => 'BRL ',
        'CAD' => 'CAD ',
        'CNY' => 'CNY ',
        'EUR' => 'EUR ',
        'GBP' => 'GBP ',
        'HKD' => 'HKD ',
        'ILS' => 'ILS ',
        'INR' => 'INR ',
        'JPY' => '¥',
        'KRW' => 'KRW ',
        'MXN' => 'MXN ',
        'NZD' => 'NZD ',
        'THB' => 'THB ',
        'TWD' => 'TWD ',
        'USD' => 'USD ',
        'VND' => 'VND ',
        'XAF' => 'FCFA ',
        'XCD' => 'XCD ',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'Á',
            'M',
            'J',
            'J',
            'A',
            'Sz',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'febr.',
            'márc.',
            'ápr.',
            'máj.',
            'jún.',
            'júl.',
            'aug.',
            'szept.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'január',
            'február',
            'március',
            'április',
            'május',
            'június',
            'július',
            'augusztus',
            'szeptember',
            'október',
            'november',
            'december',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'Á',
            'M',
            'J',
            'J',
            'A',
            'Sz',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'febr.',
            'márc.',
            'ápr.',
            'máj.',
            'jún.',
            'júl.',
            'aug.',
            'szept.',
            'okt.',
            'nov.',
            'dec.',
        ],
        'full' => [
            'január',
            'február',
            'március',
            'április',
            'május',
            'június',
            'július',
            'augusztus',
            'szeptember',
            'október',
            'november',
            'december',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'V',
            'H',
            'K',
            'Sz',
            'Cs',
            'P',
            'Sz',
        ],
        'short' => [
            'V',
            'H',
            'K',
            'Sze',
            'Cs',
            'P',
            'Szo',
        ],
        'medium' => [
            'V',
            'H',
            'K',
            'Sze',
            'Cs',
            'P',
            'Szo',
        ],
        'full' => [
            'vasárnap',
            'hétfő',
            'kedd',
            'szerda',
            'csütörtök',
            'péntek',
            'szombat',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'V',
            'H',
            'K',
            'Sz',
            'Cs',
            'P',
            'Sz',
        ],
        'short' => [
            'V',
            'H',
            'K',
            'Sze',
            'Cs',
            'P',
            'Szo',
        ],
        'medium' => [
            'V',
            'H',
            'K',
            'Sze',
            'Cs',
            'P',
            'Szo',
        ],
        'full' => [
            'vasárnap',
            'hétfő',
            'kedd',
            'szerda',
            'csütörtök',
            'péntek',
            'szombat',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namíbia)',
        'af-ZA' => 'afrikaans (Dél-afrikai Köztársaság)',
        'agq' => 'agem',
        'agq-CM' => 'agem (Kamerun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghána)',
        'am' => 'amhara',
        'am-ET' => 'amhara (Etiópia)',
        'ar' => 'arab',
        'ar-001' => 'arab (Világ)',
        'ar-AE' => 'arab (Egyesült Arab Emírségek)',
        'ar-BH' => 'arab (Bahrein)',
        'ar-DJ' => 'arab (Dzsibuti)',
        'ar-DZ' => 'arab (Algéria)',
        'ar-EG' => 'arab (Egyiptom)',
        'ar-EH' => 'arab (Nyugat-Szahara)',
        'ar-ER' => 'arab (Eritrea)',
        'ar-IL' => 'arab (Izrael)',
        'ar-IQ' => 'arab (Irak)',
        'ar-JO' => 'arab (Jordánia)',
        'ar-KM' => 'arab (Comore-szigetek)',
        'ar-KW' => 'arab (Kuvait)',
        'ar-LB' => 'arab (Libanon)',
        'ar-LY' => 'arab (Líbia)',
        'ar-MA' => 'arab (Marokkó)',
        'ar-MR' => 'arab (Mauritánia)',
        'ar-OM' => 'arab (Omán)',
        'ar-PS' => 'arab (Palesztin Terület)',
        'ar-QA' => 'arab (Katar)',
        'ar-SA' => 'arab (Szaúd-Arábia)',
        'ar-SD' => 'arab (Szudán)',
        'ar-SO' => 'arab (Szomália)',
        'ar-SS' => 'arab (Dél-Szudán)',
        'ar-SY' => 'arab (Szíria)',
        'ar-TD' => 'arab (Csád)',
        'ar-TN' => 'arab (Tunézia)',
        'ar-YE' => 'arab (Jemen)',
        'as' => 'asszámi',
        'as-IN' => 'asszámi (India)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzánia)',
        'ast' => 'asztúr',
        'ast-ES' => 'asztúr (Spanyolország)',
        'az' => 'azerbajdzsáni',
        'az-Cyrl' => 'azerbajdzsáni (Cirill)',
        'az-Cyrl-AZ' => 'azerbajdzsáni (Cirill, Azerbajdzsán)',
        'az-Latn' => 'azerbajdzsáni (Latin)',
        'az-Latn-AZ' => 'azerbajdzsáni (Latin, Azerbajdzsán)',
        'bas' => 'basza',
        'bas-CM' => 'basza (Kamerun)',
        'be' => 'belarusz',
        'be-BY' => 'belarusz (Belarusz)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzánia)',
        'bg' => 'bolgár',
        'bg-BG' => 'bolgár (Bulgária)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bangla',
        'bn-BD' => 'bangla (Banglades)',
        'bn-IN' => 'bangla (India)',
        'bo' => 'tibeti',
        'bo-CN' => 'tibeti (Kína)',
        'bo-IN' => 'tibeti (India)',
        'br' => 'breton',
        'br-FR' => 'breton (Franciaország)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (India)',
        'bs' => 'bosnyák',
        'bs-Cyrl' => 'bosnyák (Cirill)',
        'bs-Cyrl-BA' => 'bosnyák (Cirill, Bosznia-Hercegovina)',
        'bs-Latn' => 'bosnyák (Latin)',
        'bs-Latn-BA' => 'bosnyák (Latin, Bosznia-Hercegovina)',
        'ca' => 'katalán',
        'ca-AD' => 'katalán (Andorra)',
        'ca-ES' => 'katalán (Spanyolország)',
        'ca-FR' => 'katalán (Franciaország)',
        'ca-IT' => 'katalán (Olaszország)',
        'ccp' => 'csakma',
        'ccp-BD' => 'csakma (Banglades)',
        'ccp-IN' => 'csakma (India)',
        'ce' => 'csecsen',
        'ce-RU' => 'csecsen (Oroszország)',
        'ceb' => 'szebuano',
        'ceb-PH' => 'szebuano (Fülöp-szigetek)',
        'cgg' => 'kiga',
        'cgg-UG' => 'kiga (Uganda)',
        'chr' => 'cseroki',
        'chr-US' => 'cseroki (Egyesült Államok)',
        'ckb' => 'közép-ázsiai kurd',
        'ckb-IQ' => 'közép-ázsiai kurd (Irak)',
        'ckb-IR' => 'közép-ázsiai kurd (Irán)',
        'cs' => 'cseh',
        'cs-CZ' => 'cseh (Csehország)',
        'cy' => 'walesi',
        'cy-GB' => 'walesi (Egyesült Királyság)',
        'da' => 'dán',
        'da-DK' => 'dán (Dánia)',
        'da-GL' => 'dán (Grönland)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenya)',
        'de' => 'német',
        'de-AT' => 'német (Ausztria)',
        'de-BE' => 'német (Belgium)',
        'de-CH' => 'német (Svájc)',
        'de-DE' => 'német (Németország)',
        'de-IT' => 'német (Olaszország)',
        'de-LI' => 'német (Liechtenstein)',
        'de-LU' => 'német (Luxemburg)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'alsó-szorb',
        'dsb-DE' => 'alsó-szorb (Németország)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Kamerun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Szenegál)',
        'dz' => 'dzsonga',
        'dz-BT' => 'dzsonga (Bhután)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Kenya)',
        'ee' => 'eve',
        'ee-GH' => 'eve (Ghána)',
        'ee-TG' => 'eve (Togo)',
        'el' => 'görög',
        'el-CY' => 'görög (Ciprus)',
        'el-GR' => 'görög (Görögország)',
        'en' => 'angol',
        'en-001' => 'angol (Világ)',
        'en-150' => 'angol (Európa)',
        'en-AE' => 'angol (Egyesült Arab Emírségek)',
        'en-AG' => 'angol (Antigua és Barbuda)',
        'en-AI' => 'angol (Anguilla)',
        'en-AS' => 'angol (Amerikai Szamoa)',
        'en-AT' => 'angol (Ausztria)',
        'en-AU' => 'angol (Ausztrália)',
        'en-BB' => 'angol (Barbados)',
        'en-BE' => 'angol (Belgium)',
        'en-BI' => 'angol (Burundi)',
        'en-BM' => 'angol (Bermuda)',
        'en-BS' => 'angol (Bahama-szigetek)',
        'en-BW' => 'angol (Botswana)',
        'en-BZ' => 'angol (Belize)',
        'en-CA' => 'angol (Kanada)',
        'en-CC' => 'angol (Kókusz [Keeling]-szigetek)',
        'en-CH' => 'angol (Svájc)',
        'en-CK' => 'angol (Cook-szigetek)',
        'en-CM' => 'angol (Kamerun)',
        'en-CX' => 'angol (Karácsony-sziget)',
        'en-CY' => 'angol (Ciprus)',
        'en-DE' => 'angol (Németország)',
        'en-DG' => 'angol (Diego Garcia)',
        'en-DK' => 'angol (Dánia)',
        'en-DM' => 'angol (Dominika)',
        'en-ER' => 'angol (Eritrea)',
        'en-FI' => 'angol (Finnország)',
        'en-FJ' => 'angol (Fidzsi)',
        'en-FK' => 'angol (Falkland-szigetek)',
        'en-FM' => 'angol (Mikronézia)',
        'en-GB' => 'angol (Egyesült Királyság)',
        'en-GD' => 'angol (Grenada)',
        'en-GG' => 'angol (Guernsey)',
        'en-GH' => 'angol (Ghána)',
        'en-GI' => 'angol (Gibraltár)',
        'en-GM' => 'angol (Gambia)',
        'en-GU' => 'angol (Guam)',
        'en-GY' => 'angol (Guyana)',
        'en-HK' => 'angol (Hongkong KKT)',
        'en-IE' => 'angol (Írország)',
        'en-IL' => 'angol (Izrael)',
        'en-IM' => 'angol (Man-sziget)',
        'en-IN' => 'angol (India)',
        'en-IO' => 'angol (Brit Indiai-óceáni Terület)',
        'en-JE' => 'angol (Jersey)',
        'en-JM' => 'angol (Jamaica)',
        'en-KE' => 'angol (Kenya)',
        'en-KI' => 'angol (Kiribati)',
        'en-KN' => 'angol (Saint Kitts és Nevis)',
        'en-KY' => 'angol (Kajmán-szigetek)',
        'en-LC' => 'angol (Saint Lucia)',
        'en-LR' => 'angol (Libéria)',
        'en-LS' => 'angol (Lesotho)',
        'en-MG' => 'angol (Madagaszkár)',
        'en-MH' => 'angol (Marshall-szigetek)',
        'en-MO' => 'angol (Makaó KKT)',
        'en-MP' => 'angol (Északi Mariana-szigetek)',
        'en-MS' => 'angol (Montserrat)',
        'en-MT' => 'angol (Málta)',
        'en-MU' => 'angol (Mauritius)',
        'en-MW' => 'angol (Malawi)',
        'en-MY' => 'angol (Malajzia)',
        'en-NA' => 'angol (Namíbia)',
        'en-NF' => 'angol (Norfolk-sziget)',
        'en-NG' => 'angol (Nigéria)',
        'en-NL' => 'angol (Hollandia)',
        'en-NR' => 'angol (Nauru)',
        'en-NU' => 'angol (Niue)',
        'en-NZ' => 'angol (Új-Zéland)',
        'en-PG' => 'angol (Pápua Új-Guinea)',
        'en-PH' => 'angol (Fülöp-szigetek)',
        'en-PK' => 'angol (Pakisztán)',
        'en-PN' => 'angol (Pitcairn-szigetek)',
        'en-PR' => 'angol (Puerto Rico)',
        'en-PW' => 'angol (Palau)',
        'en-RW' => 'angol (Ruanda)',
        'en-SB' => 'angol (Salamon-szigetek)',
        'en-SC' => 'angol (Seychelle-szigetek)',
        'en-SD' => 'angol (Szudán)',
        'en-SE' => 'angol (Svédország)',
        'en-SG' => 'angol (Szingapúr)',
        'en-SH' => 'angol (Szent Ilona)',
        'en-SI' => 'angol (Szlovénia)',
        'en-SL' => 'angol (Sierra Leone)',
        'en-SS' => 'angol (Dél-Szudán)',
        'en-SX' => 'angol (Sint Maarten)',
        'en-SZ' => 'angol (Szváziföld)',
        'en-TC' => 'angol (Turks- és Caicos-szigetek)',
        'en-TK' => 'angol (Tokelau)',
        'en-TO' => 'angol (Tonga)',
        'en-TT' => 'angol (Trinidad és Tobago)',
        'en-TV' => 'angol (Tuvalu)',
        'en-TZ' => 'angol (Tanzánia)',
        'en-UG' => 'angol (Uganda)',
        'en-UM' => 'angol (Az USA lakatlan külbirtokai)',
        'en-US' => 'angol (Egyesült Államok)',
        'en-US-POSIX' => 'angol (Egyesült Államok, Számítógép)',
        'en-VC' => 'angol (Saint Vincent és a Grenadine-szigetek)',
        'en-VG' => 'angol (Brit Virgin-szigetek)',
        'en-VI' => 'angol (Amerikai Virgin-szigetek)',
        'en-VU' => 'angol (Vanuatu)',
        'en-WS' => 'angol (Szamoa)',
        'en-ZA' => 'angol (Dél-afrikai Köztársaság)',
        'en-ZM' => 'angol (Zambia)',
        'en-ZW' => 'angol (Zimbabwe)',
        'eo' => 'eszperantó',
        'eo-001' => 'eszperantó (Világ)',
        'es' => 'spanyol',
        'es-419' => 'spanyol (Latin-Amerika)',
        'es-AR' => 'spanyol (Argentína)',
        'es-BO' => 'spanyol (Bolívia)',
        'es-BR' => 'spanyol (Brazília)',
        'es-BZ' => 'spanyol (Belize)',
        'es-CL' => 'spanyol (Chile)',
        'es-CO' => 'spanyol (Kolumbia)',
        'es-CR' => 'spanyol (Costa Rica)',
        'es-CU' => 'spanyol (Kuba)',
        'es-DO' => 'spanyol (Dominikai Köztársaság)',
        'es-EA' => 'spanyol (Ceuta és Melilla)',
        'es-EC' => 'spanyol (Ecuador)',
        'es-ES' => 'spanyol (Spanyolország)',
        'es-GQ' => 'spanyol (Egyenlítői-Guinea)',
        'es-GT' => 'spanyol (Guatemala)',
        'es-HN' => 'spanyol (Honduras)',
        'es-IC' => 'spanyol (Kanári-szigetek)',
        'es-MX' => 'spanyol (Mexikó)',
        'es-NI' => 'spanyol (Nicaragua)',
        'es-PA' => 'spanyol (Panama)',
        'es-PE' => 'spanyol (Peru)',
        'es-PH' => 'spanyol (Fülöp-szigetek)',
        'es-PR' => 'spanyol (Puerto Rico)',
        'es-PY' => 'spanyol (Paraguay)',
        'es-SV' => 'spanyol (Salvador)',
        'es-US' => 'spanyol (Egyesült Államok)',
        'es-UY' => 'spanyol (Uruguay)',
        'es-VE' => 'spanyol (Venezuela)',
        'et' => 'észt',
        'et-EE' => 'észt (Észtország)',
        'eu' => 'baszk',
        'eu-ES' => 'baszk (Spanyolország)',
        'ewo' => 'evondo',
        'ewo-CM' => 'evondo (Kamerun)',
        'fa' => 'perzsa',
        'fa-AF' => 'perzsa (Afganisztán)',
        'fa-IR' => 'perzsa (Irán)',
        'ff' => 'fulani',
        'ff-Latn' => 'fulani (Latin)',
        'ff-Latn-BF' => 'fulani (Latin, Burkina Faso)',
        'ff-Latn-CM' => 'fulani (Latin, Kamerun)',
        'ff-Latn-GH' => 'fulani (Latin, Ghána)',
        'ff-Latn-GM' => 'fulani (Latin, Gambia)',
        'ff-Latn-GN' => 'fulani (Latin, Guinea)',
        'ff-Latn-GW' => 'fulani (Latin, Bissau-Guinea)',
        'ff-Latn-LR' => 'fulani (Latin, Libéria)',
        'ff-Latn-MR' => 'fulani (Latin, Mauritánia)',
        'ff-Latn-NE' => 'fulani (Latin, Niger)',
        'ff-Latn-NG' => 'fulani (Latin, Nigéria)',
        'ff-Latn-SL' => 'fulani (Latin, Sierra Leone)',
        'ff-Latn-SN' => 'fulani (Latin, Szenegál)',
        'fi' => 'finn',
        'fi-FI' => 'finn (Finnország)',
        'fil' => 'filippínó',
        'fil-PH' => 'filippínó (Fülöp-szigetek)',
        'fo' => 'feröeri',
        'fo-DK' => 'feröeri (Dánia)',
        'fo-FO' => 'feröeri (Feröer szigetek)',
        'fr' => 'francia',
        'fr-BE' => 'francia (Belgium)',
        'fr-BF' => 'francia (Burkina Faso)',
        'fr-BI' => 'francia (Burundi)',
        'fr-BJ' => 'francia (Benin)',
        'fr-BL' => 'francia (Saint-Barthélemy)',
        'fr-CA' => 'francia (Kanada)',
        'fr-CD' => 'francia (Kongó - Kinshasa)',
        'fr-CF' => 'francia (Közép-afrikai Köztársaság)',
        'fr-CG' => 'francia (Kongó - Brazzaville)',
        'fr-CH' => 'francia (Svájc)',
        'fr-CI' => 'francia (Elefántcsontpart)',
        'fr-CM' => 'francia (Kamerun)',
        'fr-DJ' => 'francia (Dzsibuti)',
        'fr-DZ' => 'francia (Algéria)',
        'fr-FR' => 'francia (Franciaország)',
        'fr-GA' => 'francia (Gabon)',
        'fr-GF' => 'francia (Francia Guyana)',
        'fr-GN' => 'francia (Guinea)',
        'fr-GP' => 'francia (Guadeloupe)',
        'fr-GQ' => 'francia (Egyenlítői-Guinea)',
        'fr-HT' => 'francia (Haiti)',
        'fr-KM' => 'francia (Comore-szigetek)',
        'fr-LU' => 'francia (Luxemburg)',
        'fr-MA' => 'francia (Marokkó)',
        'fr-MC' => 'francia (Monaco)',
        'fr-MF' => 'francia (Saint Martin)',
        'fr-MG' => 'francia (Madagaszkár)',
        'fr-ML' => 'francia (Mali)',
        'fr-MQ' => 'francia (Martinique)',
        'fr-MR' => 'francia (Mauritánia)',
        'fr-MU' => 'francia (Mauritius)',
        'fr-NC' => 'francia (Új-Kaledónia)',
        'fr-NE' => 'francia (Niger)',
        'fr-PF' => 'francia (Francia Polinézia)',
        'fr-PM' => 'francia (Saint-Pierre és Miquelon)',
        'fr-RE' => 'francia (Réunion)',
        'fr-RW' => 'francia (Ruanda)',
        'fr-SC' => 'francia (Seychelle-szigetek)',
        'fr-SN' => 'francia (Szenegál)',
        'fr-SY' => 'francia (Szíria)',
        'fr-TD' => 'francia (Csád)',
        'fr-TG' => 'francia (Togo)',
        'fr-TN' => 'francia (Tunézia)',
        'fr-VU' => 'francia (Vanuatu)',
        'fr-WF' => 'francia (Wallis és Futuna)',
        'fr-YT' => 'francia (Mayotte)',
        'fur' => 'friuli',
        'fur-IT' => 'friuli (Olaszország)',
        'fy' => 'nyugati fríz',
        'fy-NL' => 'nyugati fríz (Hollandia)',
        'ga' => 'ír',
        'ga-IE' => 'ír (Írország)',
        'gd' => 'skóciai kelta',
        'gd-GB' => 'skóciai kelta (Egyesült Királyság)',
        'gl' => 'gallego',
        'gl-ES' => 'gallego (Spanyolország)',
        'gsw' => 'svájci német',
        'gsw-CH' => 'svájci német (Svájc)',
        'gsw-FR' => 'svájci német (Franciaország)',
        'gsw-LI' => 'svájci német (Liechtenstein)',
        'gu' => 'gudzsaráti',
        'gu-IN' => 'gudzsaráti (India)',
        'guz' => 'guszii',
        'guz-KE' => 'guszii (Kenya)',
        'gv' => 'man-szigeti',
        'gv-IM' => 'man-szigeti (Man-sziget)',
        'ha' => 'hausza',
        'ha-GH' => 'hausza (Ghána)',
        'ha-NE' => 'hausza (Niger)',
        'ha-NG' => 'hausza (Nigéria)',
        'haw' => 'hawaii',
        'haw-US' => 'hawaii (Egyesült Államok)',
        'he' => 'héber',
        'he-IL' => 'héber (Izrael)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (India)',
        'hr' => 'horvát',
        'hr-BA' => 'horvát (Bosznia-Hercegovina)',
        'hr-HR' => 'horvát (Horvátország)',
        'hsb' => 'felső-szorb',
        'hsb-DE' => 'felső-szorb (Németország)',
        'hu' => 'magyar',
        'hu-HU' => 'magyar (Magyarország)',
        'hy' => 'örmény',
        'hy-AM' => 'örmény (Örményország)',
        'ia' => 'interlingva',
        'ia-001' => 'interlingva (Világ)',
        'id' => 'indonéz',
        'id-ID' => 'indonéz (Indonézia)',
        'ig' => 'igbó',
        'ig-NG' => 'igbó (Nigéria)',
        'ii' => 'szecsuán ji',
        'ii-CN' => 'szecsuán ji (Kína)',
        'is' => 'izlandi',
        'is-IS' => 'izlandi (Izland)',
        'it' => 'olasz',
        'it-CH' => 'olasz (Svájc)',
        'it-IT' => 'olasz (Olaszország)',
        'it-SM' => 'olasz (San Marino)',
        'it-VA' => 'olasz (Vatikán)',
        'ja' => 'japán',
        'ja-JP' => 'japán (Japán)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Kamerun)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzánia)',
        'jv' => 'jávai',
        'jv-ID' => 'jávai (Indonézia)',
        'ka' => 'grúz',
        'ka-GE' => 'grúz (Grúzia)',
        'kab' => 'kabije',
        'kab-DZ' => 'kabije (Algéria)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzánia)',
        'kea' => 'kabuverdianu',
        'kea-CV' => 'kabuverdianu (Zöld-foki Köztársaság)',
        'khq' => 'kojra-csíni',
        'khq-ML' => 'kojra-csíni (Mali)',
        'ki' => 'kikuju',
        'ki-KE' => 'kikuju (Kenya)',
        'kk' => 'kazah',
        'kk-KZ' => 'kazah (Kazahsztán)',
        'kkj' => 'kakó',
        'kkj-CM' => 'kakó (Kamerun)',
        'kl' => 'grönlandi',
        'kl-GL' => 'grönlandi (Grönland)',
        'kln' => 'kalendzsin',
        'kln-KE' => 'kalendzsin (Kenya)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Kambodzsa)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (India)',
        'ko' => 'koreai',
        'ko-KP' => 'koreai (Észak-Korea)',
        'ko-KR' => 'koreai (Dél-Korea)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (India)',
        'ks' => 'kasmíri',
        'ks-IN' => 'kasmíri (India)',
        'ksb' => 'sambala',
        'ksb-TZ' => 'sambala (Tanzánia)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'kölsch',
        'ksh-DE' => 'kölsch (Németország)',
        'ku' => 'kurd',
        'ku-TR' => 'kurd (Törökország)',
        'kw' => 'korni',
        'kw-GB' => 'korni (Egyesült Királyság)',
        'ky' => 'kirgiz',
        'ky-KG' => 'kirgiz (Kirgizisztán)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzánia)',
        'lb' => 'luxemburgi',
        'lb-LU' => 'luxemburgi (Luxemburg)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (Egyesült Államok)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Kongó - Kinshasa)',
        'ln-CF' => 'lingala (Közép-afrikai Köztársaság)',
        'ln-CG' => 'lingala (Kongó - Brazzaville)',
        'lo' => 'lao',
        'lo-LA' => 'lao (Laosz)',
        'lrc' => 'északi luri',
        'lrc-IQ' => 'északi luri (Irak)',
        'lrc-IR' => 'északi luri (Irán)',
        'lt' => 'litván',
        'lt-LT' => 'litván (Litvánia)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Kongó - Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'lujia',
        'luy-KE' => 'lujia (Kenya)',
        'lv' => 'lett',
        'lv-LV' => 'lett (Lettország)',
        'mas' => 'masai',
        'mas-KE' => 'masai (Kenya)',
        'mas-TZ' => 'masai (Tanzánia)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenya)',
        'mfe' => 'mauritiusi kreol',
        'mfe-MU' => 'mauritiusi kreol (Mauritius)',
        'mg' => 'malgas',
        'mg-MG' => 'malgas (Madagaszkár)',
        'mgh' => 'makua-metó',
        'mgh-MZ' => 'makua-metó (Mozambik)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Kamerun)',
        'mi' => 'maori',
        'mi-NZ' => 'maori (Új-Zéland)',
        'mk' => 'macedón',
        'mk-MK' => 'macedón (Észak-Macedónia)',
        'ml' => 'malajálam',
        'ml-IN' => 'malajálam (India)',
        'mn' => 'mongol',
        'mn-MN' => 'mongol (Mongólia)',
        'mr' => 'maráthi',
        'mr-IN' => 'maráthi (India)',
        'ms' => 'maláj',
        'ms-BN' => 'maláj (Brunei)',
        'ms-MY' => 'maláj (Malajzia)',
        'ms-SG' => 'maláj (Szingapúr)',
        'mt' => 'máltai',
        'mt-MT' => 'máltai (Málta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'burmai',
        'my-MM' => 'burmai (Mianmar [Burma])',
        'mzn' => 'mázanderáni',
        'mzn-IR' => 'mázanderáni (Irán)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namíbia)',
        'nb' => 'norvég (bokmål)',
        'nb-NO' => 'norvég (bokmål) (Norvégia)',
        'nb-SJ' => 'norvég (bokmål) (Svalbard és Jan Mayen)',
        'nd' => 'északi ndebele',
        'nd-ZW' => 'északi ndebele (Zimbabwe)',
        'nds' => 'alsónémet',
        'nds-DE' => 'alsónémet (Németország)',
        'nds-NL' => 'alsónémet (Hollandia)',
        'ne' => 'nepáli',
        'ne-IN' => 'nepáli (India)',
        'ne-NP' => 'nepáli (Nepál)',
        'nl' => 'holland',
        'nl-AW' => 'holland (Aruba)',
        'nl-BE' => 'holland (Belgium)',
        'nl-BQ' => 'holland (Holland Karib-térség)',
        'nl-CW' => 'holland (Curaçao)',
        'nl-NL' => 'holland (Hollandia)',
        'nl-SR' => 'holland (Suriname)',
        'nl-SX' => 'holland (Sint Maarten)',
        'nmg' => 'ngumba',
        'nmg-CM' => 'ngumba (Kamerun)',
        'nn' => 'norvég (nynorsk)',
        'nn-NO' => 'norvég (nynorsk) (Norvégia)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Kamerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Dél-Szudán)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiópia)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'odia',
        'or-IN' => 'odia (India)',
        'os' => 'oszét',
        'os-GE' => 'oszét (Grúzia)',
        'os-RU' => 'oszét (Oroszország)',
        'pa' => 'pandzsábi',
        'pa-Arab' => 'pandzsábi (Arab)',
        'pa-Arab-PK' => 'pandzsábi (Arab, Pakisztán)',
        'pa-Guru' => 'pandzsábi (Gurmuki)',
        'pa-Guru-IN' => 'pandzsábi (Gurmuki, India)',
        'pl' => 'lengyel',
        'pl-PL' => 'lengyel (Lengyelország)',
        'ps' => 'pastu',
        'ps-AF' => 'pastu (Afganisztán)',
        'ps-PK' => 'pastu (Pakisztán)',
        'pt' => 'portugál',
        'pt-AO' => 'portugál (Angola)',
        'pt-BR' => 'portugál (Brazília)',
        'pt-CH' => 'portugál (Svájc)',
        'pt-CV' => 'portugál (Zöld-foki Köztársaság)',
        'pt-GQ' => 'portugál (Egyenlítői-Guinea)',
        'pt-GW' => 'portugál (Bissau-Guinea)',
        'pt-LU' => 'portugál (Luxemburg)',
        'pt-MO' => 'portugál (Makaó KKT)',
        'pt-MZ' => 'portugál (Mozambik)',
        'pt-PT' => 'portugál (Portugália)',
        'pt-ST' => 'portugál (São Tomé és Príncipe)',
        'pt-TL' => 'portugál (Kelet-Timor)',
        'qu' => 'kecsua',
        'qu-BO' => 'kecsua (Bolívia)',
        'qu-EC' => 'kecsua (Ecuador)',
        'qu-PE' => 'kecsua (Peru)',
        'rm' => 'rétoromán',
        'rm-CH' => 'rétoromán (Svájc)',
        'rn' => 'kirundi',
        'rn-BI' => 'kirundi (Burundi)',
        'ro' => 'román',
        'ro-MD' => 'román (Moldova)',
        'ro-RO' => 'román (Románia)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzánia)',
        'ru' => 'orosz',
        'ru-BY' => 'orosz (Belarusz)',
        'ru-KG' => 'orosz (Kirgizisztán)',
        'ru-KZ' => 'orosz (Kazahsztán)',
        'ru-MD' => 'orosz (Moldova)',
        'ru-RU' => 'orosz (Oroszország)',
        'ru-UA' => 'orosz (Ukrajna)',
        'rw' => 'kinyarvanda',
        'rw-RW' => 'kinyarvanda (Ruanda)',
        'rwk' => 'rwo',
        'rwk-TZ' => 'rwo (Tanzánia)',
        'sah' => 'szaha',
        'sah-RU' => 'szaha (Oroszország)',
        'saq' => 'szamburu',
        'saq-KE' => 'szamburu (Kenya)',
        'sbp' => 'szangu',
        'sbp-TZ' => 'szangu (Tanzánia)',
        'sd' => 'szindhi',
        'sd-PK' => 'szindhi (Pakisztán)',
        'se' => 'északi számi',
        'se-FI' => 'északi számi (Finnország)',
        'se-NO' => 'északi számi (Norvégia)',
        'se-SE' => 'északi számi (Svédország)',
        'seh' => 'szena',
        'seh-MZ' => 'szena (Mozambik)',
        'ses' => 'kojra-szenni',
        'ses-ML' => 'kojra-szenni (Mali)',
        'sg' => 'szangó',
        'sg-CF' => 'szangó (Közép-afrikai Köztársaság)',
        'shi' => 'tachelhit',
        'shi-Latn' => 'tachelhit (Latin)',
        'shi-Latn-MA' => 'tachelhit (Latin, Marokkó)',
        'shi-Tfng' => 'tachelhit (Berber)',
        'shi-Tfng-MA' => 'tachelhit (Berber, Marokkó)',
        'si' => 'szingaléz',
        'si-LK' => 'szingaléz (Srí Lanka)',
        'sk' => 'szlovák',
        'sk-SK' => 'szlovák (Szlovákia)',
        'sl' => 'szlovén',
        'sl-SI' => 'szlovén (Szlovénia)',
        'smn' => 'inari számi',
        'smn-FI' => 'inari számi (Finnország)',
        'sn' => 'sona',
        'sn-ZW' => 'sona (Zimbabwe)',
        'so' => 'szomáli',
        'so-DJ' => 'szomáli (Dzsibuti)',
        'so-ET' => 'szomáli (Etiópia)',
        'so-KE' => 'szomáli (Kenya)',
        'so-SO' => 'szomáli (Szomália)',
        'sq' => 'albán',
        'sq-AL' => 'albán (Albánia)',
        'sq-MK' => 'albán (Észak-Macedónia)',
        'sq-XK' => 'albán (Koszovó)',
        'sr' => 'szerb',
        'sr-Cyrl' => 'szerb (Cirill)',
        'sr-Cyrl-BA' => 'szerb (Cirill, Bosznia-Hercegovina)',
        'sr-Cyrl-ME' => 'szerb (Cirill, Montenegró)',
        'sr-Cyrl-RS' => 'szerb (Cirill, Szerbia)',
        'sr-Cyrl-XK' => 'szerb (Cirill, Koszovó)',
        'sr-Latn' => 'szerb (Latin)',
        'sr-Latn-BA' => 'szerb (Latin, Bosznia-Hercegovina)',
        'sr-Latn-ME' => 'szerb (Latin, Montenegró)',
        'sr-Latn-RS' => 'szerb (Latin, Szerbia)',
        'sr-Latn-XK' => 'szerb (Latin, Koszovó)',
        'sv' => 'svéd',
        'sv-AX' => 'svéd (Åland-szigetek)',
        'sv-FI' => 'svéd (Finnország)',
        'sv-SE' => 'svéd (Svédország)',
        'sw' => 'szuahéli',
        'sw-CD' => 'szuahéli (Kongó - Kinshasa)',
        'sw-KE' => 'szuahéli (Kenya)',
        'sw-TZ' => 'szuahéli (Tanzánia)',
        'sw-UG' => 'szuahéli (Uganda)',
        'ta' => 'tamil',
        'ta-IN' => 'tamil (India)',
        'ta-LK' => 'tamil (Srí Lanka)',
        'ta-MY' => 'tamil (Malajzia)',
        'ta-SG' => 'tamil (Szingapúr)',
        'te' => 'telugu',
        'te-IN' => 'telugu (India)',
        'teo' => 'teszó',
        'teo-KE' => 'teszó (Kenya)',
        'teo-UG' => 'teszó (Uganda)',
        'tg' => 'tadzsik',
        'tg-TJ' => 'tadzsik (Tádzsikisztán)',
        'th' => 'thai',
        'th-TH' => 'thai (Thaiföld)',
        'ti' => 'tigrinya',
        'ti-ER' => 'tigrinya (Eritrea)',
        'ti-ET' => 'tigrinya (Etiópia)',
        'tk' => 'türkmén',
        'tk-TM' => 'türkmén (Türkmenisztán)',
        'to' => 'tongai',
        'to-TO' => 'tongai (Tonga)',
        'tr' => 'török',
        'tr-CY' => 'török (Ciprus)',
        'tr-TR' => 'török (Törökország)',
        'tt' => 'tatár',
        'tt-RU' => 'tatár (Oroszország)',
        'twq' => 'szavák',
        'twq-NE' => 'szavák (Niger)',
        'tzm' => 'közép-atlaszi tamazigt',
        'tzm-MA' => 'közép-atlaszi tamazigt (Marokkó)',
        'ug' => 'ujgur',
        'ug-CN' => 'ujgur (Kína)',
        'uk' => 'ukrán',
        'uk-UA' => 'ukrán (Ukrajna)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (India)',
        'ur-PK' => 'urdu (Pakisztán)',
        'uz' => 'üzbég',
        'uz-Arab' => 'üzbég (Arab)',
        'uz-Arab-AF' => 'üzbég (Arab, Afganisztán)',
        'uz-Cyrl' => 'üzbég (Cirill)',
        'uz-Cyrl-UZ' => 'üzbég (Cirill, Üzbegisztán)',
        'uz-Latn' => 'üzbég (Latin)',
        'uz-Latn-UZ' => 'üzbég (Latin, Üzbegisztán)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (Latin)',
        'vai-Latn-LR' => 'vai (Latin, Libéria)',
        'vai-Vaii' => 'vai (Vai)',
        'vai-Vaii-LR' => 'vai (Vai, Libéria)',
        'vi' => 'vietnami',
        'vi-VN' => 'vietnami (Vietnám)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzánia)',
        'wae' => 'walser',
        'wae-CH' => 'walser (Svájc)',
        'wo' => 'volof',
        'wo-SN' => 'volof (Szenegál)',
        'xh' => 'xhosza',
        'xh-ZA' => 'xhosza (Dél-afrikai Köztársaság)',
        'xog' => 'szoga',
        'xog-UG' => 'szoga (Uganda)',
        'yav' => 'jangben',
        'yav-CM' => 'jangben (Kamerun)',
        'yi' => 'jiddis',
        'yi-001' => 'jiddis (Világ)',
        'yo' => 'joruba',
        'yo-BJ' => 'joruba (Benin)',
        'yo-NG' => 'joruba (Nigéria)',
        'yue' => 'kantoni',
        'yue-Hans' => 'kantoni (Egyszerűsített)',
        'yue-Hans-CN' => 'kantoni (Egyszerűsített, Kína)',
        'yue-Hant' => 'kantoni (Hagyományos)',
        'yue-Hant-HK' => 'kantoni (Hagyományos, Hongkong KKT)',
        'zgh' => 'marokkói tamazight',
        'zgh-MA' => 'marokkói tamazight (Marokkó)',
        'zh' => 'kínai',
        'zh-Hans' => 'kínai (Egyszerűsített)',
        'zh-Hans-CN' => 'kínai (Egyszerűsített, Kína)',
        'zh-Hans-HK' => 'kínai (Egyszerűsített, Hongkong KKT)',
        'zh-Hans-MO' => 'kínai (Egyszerűsített, Makaó KKT)',
        'zh-Hans-SG' => 'kínai (Egyszerűsített, Szingapúr)',
        'zh-Hant' => 'kínai (Hagyományos)',
        'zh-Hant-HK' => 'kínai (Hagyományos, Hongkong KKT)',
        'zh-Hant-MO' => 'kínai (Hagyományos, Makaó KKT)',
        'zh-Hant-TW' => 'kínai (Hagyományos, Tajvan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Dél-afrikai Köztársaság)',
    ],
];
