<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'dd.MM.y',
            'time' => 'HH:mm',
            'datetime' => 'dd.MM.y, HH:mm',
        ],
        'medium' => [
            'date' => 'd. MMM y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd. MMM y, HH:mm:ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd. MMMM y \'kl\'. HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d. MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE d. MMMM y HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '¤ #,##0.00',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'a.m.',
    'pmName' => 'p.m.',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '−',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '−',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'AUD ',
        'BRL' => 'BRL ',
        'CAD' => 'CAD ',
        'CNY' => 'CNY ',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HKD ',
        'ILS' => 'ILS ',
        'INR' => 'INR ',
        'JPY' => 'JPY ',
        'KRW' => 'KRW ',
        'MXN' => 'MXN ',
        'NZD' => 'NZD ',
        'THB' => 'THB ',
        'TWD' => 'TWD ',
        'USD' => 'USD ',
        'VND' => 'VND ',
        'XAF' => 'XAF ',
        'XCD' => 'XCD ',
        'XOF' => 'CFA ',
        'XPF' => 'XPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan',
            'feb',
            'mar',
            'apr',
            'mai',
            'jun',
            'jul',
            'aug',
            'sep',
            'okt',
            'nov',
            'des',
        ],
        'full' => [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'mai',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'des.',
        ],
        'full' => [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sø.',
            'ma.',
            'ti.',
            'on.',
            'to.',
            'fr.',
            'lø.',
        ],
        'medium' => [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.',
        ],
        'full' => [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'T',
            'O',
            'T',
            'F',
            'L',
        ],
        'short' => [
            'sø.',
            'ma.',
            'ti.',
            'on.',
            'to.',
            'fr.',
            'lø.',
        ],
        'medium' => [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.',
        ],
        'full' => [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikaans',
        'af-NA' => 'afrikaans (Namibia)',
        'af-ZA' => 'afrikaans (Sør-Afrika)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Kamerun)',
        'ak' => 'akan',
        'ak-GH' => 'akan (Ghana)',
        'am' => 'amharisk',
        'am-ET' => 'amharisk (Etiopia)',
        'ar' => 'arabisk',
        'ar-001' => 'arabisk (verden)',
        'ar-AE' => 'arabisk (De forente arabiske emirater)',
        'ar-BH' => 'arabisk (Bahrain)',
        'ar-DJ' => 'arabisk (Djibouti)',
        'ar-DZ' => 'arabisk (Algerie)',
        'ar-EG' => 'arabisk (Egypt)',
        'ar-EH' => 'arabisk (Vest-Sahara)',
        'ar-ER' => 'arabisk (Eritrea)',
        'ar-IL' => 'arabisk (Israel)',
        'ar-IQ' => 'arabisk (Irak)',
        'ar-JO' => 'arabisk (Jordan)',
        'ar-KM' => 'arabisk (Komorene)',
        'ar-KW' => 'arabisk (Kuwait)',
        'ar-LB' => 'arabisk (Libanon)',
        'ar-LY' => 'arabisk (Libya)',
        'ar-MA' => 'arabisk (Marokko)',
        'ar-MR' => 'arabisk (Mauritania)',
        'ar-OM' => 'arabisk (Oman)',
        'ar-PS' => 'arabisk (Det palestinske området)',
        'ar-QA' => 'arabisk (Qatar)',
        'ar-SA' => 'arabisk (Saudi-Arabia)',
        'ar-SD' => 'arabisk (Sudan)',
        'ar-SO' => 'arabisk (Somalia)',
        'ar-SS' => 'arabisk (Sør-Sudan)',
        'ar-SY' => 'arabisk (Syria)',
        'ar-TD' => 'arabisk (Tsjad)',
        'ar-TN' => 'arabisk (Tunisia)',
        'ar-YE' => 'arabisk (Jemen)',
        'as' => 'assamesisk',
        'as-IN' => 'assamesisk (India)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzania)',
        'ast' => 'asturisk',
        'ast-ES' => 'asturisk (Spania)',
        'az' => 'aserbajdsjansk',
        'az-Cyrl' => 'aserbajdsjansk (kyrillisk)',
        'az-Cyrl-AZ' => 'aserbajdsjansk (kyrillisk, Aserbajdsjan)',
        'az-Latn' => 'aserbajdsjansk (latinsk)',
        'az-Latn-AZ' => 'aserbajdsjansk (latinsk, Aserbajdsjan)',
        'bas' => 'basaa',
        'bas-CM' => 'basaa (Kamerun)',
        'be' => 'hviterussisk',
        'be-BY' => 'hviterussisk (Hviterussland)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzania)',
        'bg' => 'bulgarsk',
        'bg-BG' => 'bulgarsk (Bulgaria)',
        'bm' => 'bambara',
        'bm-ML' => 'bambara (Mali)',
        'bn' => 'bengali',
        'bn-BD' => 'bengali (Bangladesh)',
        'bn-IN' => 'bengali (India)',
        'bo' => 'tibetansk',
        'bo-CN' => 'tibetansk (Kina)',
        'bo-IN' => 'tibetansk (India)',
        'br' => 'bretonsk',
        'br-FR' => 'bretonsk (Frankrike)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (India)',
        'bs' => 'bosnisk',
        'bs-Cyrl' => 'bosnisk (kyrillisk)',
        'bs-Cyrl-BA' => 'bosnisk (kyrillisk, Bosnia-Hercegovina)',
        'bs-Latn' => 'bosnisk (latinsk)',
        'bs-Latn-BA' => 'bosnisk (latinsk, Bosnia-Hercegovina)',
        'ca' => 'katalansk',
        'ca-AD' => 'katalansk (Andorra)',
        'ca-ES' => 'katalansk (Spania)',
        'ca-FR' => 'katalansk (Frankrike)',
        'ca-IT' => 'katalansk (Italia)',
        'ccp' => 'ccp',
        'ccp-BD' => 'ccp (Bangladesh)',
        'ccp-IN' => 'ccp (India)',
        'ce' => 'tsjetsjensk',
        'ce-RU' => 'tsjetsjensk (Russland)',
        'ceb' => 'cebuansk',
        'ceb-PH' => 'cebuansk (Filippinene)',
        'cgg' => 'kiga',
        'cgg-UG' => 'kiga (Uganda)',
        'chr' => 'cherokesisk',
        'chr-US' => 'cherokesisk (USA)',
        'ckb' => 'kurdisk (sorani)',
        'ckb-IQ' => 'kurdisk (sorani) (Irak)',
        'ckb-IR' => 'kurdisk (sorani) (Iran)',
        'cs' => 'tsjekkisk',
        'cs-CZ' => 'tsjekkisk (Tsjekkia)',
        'cy' => 'walisisk',
        'cy-GB' => 'walisisk (Storbritannia)',
        'da' => 'dansk',
        'da-DK' => 'dansk (Danmark)',
        'da-GL' => 'dansk (Grønland)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Kenya)',
        'de' => 'tysk',
        'de-AT' => 'tysk (Østerrike)',
        'de-BE' => 'tysk (Belgia)',
        'de-CH' => 'tysk (Sveits)',
        'de-DE' => 'tysk (Tyskland)',
        'de-IT' => 'tysk (Italia)',
        'de-LI' => 'tysk (Liechtenstein)',
        'de-LU' => 'tysk (Luxemburg)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'lavsorbisk',
        'dsb-DE' => 'lavsorbisk (Tyskland)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Kamerun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhutan)',
        'ebu' => 'kiembu',
        'ebu-KE' => 'kiembu (Kenya)',
        'ee' => 'ewe',
        'ee-GH' => 'ewe (Ghana)',
        'ee-TG' => 'ewe (Togo)',
        'el' => 'gresk',
        'el-CY' => 'gresk (Kypros)',
        'el-GR' => 'gresk (Hellas)',
        'en' => 'engelsk',
        'en-001' => 'engelsk (verden)',
        'en-150' => 'engelsk (Europa)',
        'en-AE' => 'engelsk (De forente arabiske emirater)',
        'en-AG' => 'engelsk (Antigua og Barbuda)',
        'en-AI' => 'engelsk (Anguilla)',
        'en-AS' => 'engelsk (Amerikansk Samoa)',
        'en-AT' => 'engelsk (Østerrike)',
        'en-AU' => 'engelsk (Australia)',
        'en-BB' => 'engelsk (Barbados)',
        'en-BE' => 'engelsk (Belgia)',
        'en-BI' => 'engelsk (Burundi)',
        'en-BM' => 'engelsk (Bermuda)',
        'en-BS' => 'engelsk (Bahamas)',
        'en-BW' => 'engelsk (Botswana)',
        'en-BZ' => 'engelsk (Belize)',
        'en-CA' => 'engelsk (Canada)',
        'en-CC' => 'engelsk (Kokosøyene)',
        'en-CH' => 'engelsk (Sveits)',
        'en-CK' => 'engelsk (Cookøyene)',
        'en-CM' => 'engelsk (Kamerun)',
        'en-CX' => 'engelsk (Christmasøya)',
        'en-CY' => 'engelsk (Kypros)',
        'en-DE' => 'engelsk (Tyskland)',
        'en-DG' => 'engelsk (Diego Garcia)',
        'en-DK' => 'engelsk (Danmark)',
        'en-DM' => 'engelsk (Dominica)',
        'en-ER' => 'engelsk (Eritrea)',
        'en-FI' => 'engelsk (Finland)',
        'en-FJ' => 'engelsk (Fiji)',
        'en-FK' => 'engelsk (Falklandsøyene)',
        'en-FM' => 'engelsk (Mikronesiaføderasjonen)',
        'en-GB' => 'engelsk (Storbritannia)',
        'en-GD' => 'engelsk (Grenada)',
        'en-GG' => 'engelsk (Guernsey)',
        'en-GH' => 'engelsk (Ghana)',
        'en-GI' => 'engelsk (Gibraltar)',
        'en-GM' => 'engelsk (Gambia)',
        'en-GU' => 'engelsk (Guam)',
        'en-GY' => 'engelsk (Guyana)',
        'en-HK' => 'engelsk (Hongkong S.A.R. Kina)',
        'en-IE' => 'engelsk (Irland)',
        'en-IL' => 'engelsk (Israel)',
        'en-IM' => 'engelsk (Man)',
        'en-IN' => 'engelsk (India)',
        'en-IO' => 'engelsk (Det britiske territoriet i Indiahavet)',
        'en-JE' => 'engelsk (Jersey)',
        'en-JM' => 'engelsk (Jamaica)',
        'en-KE' => 'engelsk (Kenya)',
        'en-KI' => 'engelsk (Kiribati)',
        'en-KN' => 'engelsk (Saint Kitts og Nevis)',
        'en-KY' => 'engelsk (Caymanøyene)',
        'en-LC' => 'engelsk (St. Lucia)',
        'en-LR' => 'engelsk (Liberia)',
        'en-LS' => 'engelsk (Lesotho)',
        'en-MG' => 'engelsk (Madagaskar)',
        'en-MH' => 'engelsk (Marshalløyene)',
        'en-MO' => 'engelsk (Macao S.A.R. Kina)',
        'en-MP' => 'engelsk (Nord-Marianene)',
        'en-MS' => 'engelsk (Montserrat)',
        'en-MT' => 'engelsk (Malta)',
        'en-MU' => 'engelsk (Mauritius)',
        'en-MW' => 'engelsk (Malawi)',
        'en-MY' => 'engelsk (Malaysia)',
        'en-NA' => 'engelsk (Namibia)',
        'en-NF' => 'engelsk (Norfolkøya)',
        'en-NG' => 'engelsk (Nigeria)',
        'en-NL' => 'engelsk (Nederland)',
        'en-NR' => 'engelsk (Nauru)',
        'en-NU' => 'engelsk (Niue)',
        'en-NZ' => 'engelsk (New Zealand)',
        'en-PG' => 'engelsk (Papua Ny-Guinea)',
        'en-PH' => 'engelsk (Filippinene)',
        'en-PK' => 'engelsk (Pakistan)',
        'en-PN' => 'engelsk (Pitcairnøyene)',
        'en-PR' => 'engelsk (Puerto Rico)',
        'en-PW' => 'engelsk (Palau)',
        'en-RW' => 'engelsk (Rwanda)',
        'en-SB' => 'engelsk (Salomonøyene)',
        'en-SC' => 'engelsk (Seychellene)',
        'en-SD' => 'engelsk (Sudan)',
        'en-SE' => 'engelsk (Sverige)',
        'en-SG' => 'engelsk (Singapore)',
        'en-SH' => 'engelsk (St. Helena)',
        'en-SI' => 'engelsk (Slovenia)',
        'en-SL' => 'engelsk (Sierra Leone)',
        'en-SS' => 'engelsk (Sør-Sudan)',
        'en-SX' => 'engelsk (Sint Maarten)',
        'en-SZ' => 'engelsk (Eswatini)',
        'en-TC' => 'engelsk (Turks- og Caicosøyene)',
        'en-TK' => 'engelsk (Tokelau)',
        'en-TO' => 'engelsk (Tonga)',
        'en-TT' => 'engelsk (Trinidad og Tobago)',
        'en-TV' => 'engelsk (Tuvalu)',
        'en-TZ' => 'engelsk (Tanzania)',
        'en-UG' => 'engelsk (Uganda)',
        'en-UM' => 'engelsk (USAs ytre øyer)',
        'en-US' => 'engelsk (USA)',
        'en-US-POSIX' => 'engelsk (USA, dataspråk)',
        'en-VC' => 'engelsk (St. Vincent og Grenadinene)',
        'en-VG' => 'engelsk (De britiske jomfruøyene)',
        'en-VI' => 'engelsk (De amerikanske jomfruøyene)',
        'en-VU' => 'engelsk (Vanuatu)',
        'en-WS' => 'engelsk (Samoa)',
        'en-ZA' => 'engelsk (Sør-Afrika)',
        'en-ZM' => 'engelsk (Zambia)',
        'en-ZW' => 'engelsk (Zimbabwe)',
        'eo' => 'esperanto',
        'eo-001' => 'esperanto (verden)',
        'es' => 'spansk',
        'es-419' => 'spansk (Latin-Amerika)',
        'es-AR' => 'spansk (Argentina)',
        'es-BO' => 'spansk (Bolivia)',
        'es-BR' => 'spansk (Brasil)',
        'es-BZ' => 'spansk (Belize)',
        'es-CL' => 'spansk (Chile)',
        'es-CO' => 'spansk (Colombia)',
        'es-CR' => 'spansk (Costa Rica)',
        'es-CU' => 'spansk (Cuba)',
        'es-DO' => 'spansk (Den dominikanske republikk)',
        'es-EA' => 'spansk (Ceuta og Melilla)',
        'es-EC' => 'spansk (Ecuador)',
        'es-ES' => 'spansk (Spania)',
        'es-GQ' => 'spansk (Ekvatorial-Guinea)',
        'es-GT' => 'spansk (Guatemala)',
        'es-HN' => 'spansk (Honduras)',
        'es-IC' => 'spansk (Kanariøyene)',
        'es-MX' => 'spansk (Mexico)',
        'es-NI' => 'spansk (Nicaragua)',
        'es-PA' => 'spansk (Panama)',
        'es-PE' => 'spansk (Peru)',
        'es-PH' => 'spansk (Filippinene)',
        'es-PR' => 'spansk (Puerto Rico)',
        'es-PY' => 'spansk (Paraguay)',
        'es-SV' => 'spansk (El Salvador)',
        'es-US' => 'spansk (USA)',
        'es-UY' => 'spansk (Uruguay)',
        'es-VE' => 'spansk (Venezuela)',
        'et' => 'estisk',
        'et-EE' => 'estisk (Estland)',
        'eu' => 'baskisk',
        'eu-ES' => 'baskisk (Spania)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Kamerun)',
        'fa' => 'persisk',
        'fa-AF' => 'persisk (Afghanistan)',
        'fa-IR' => 'persisk (Iran)',
        'ff' => 'fulfulde',
        'ff-Latn' => 'fulfulde (latinsk)',
        'ff-Latn-BF' => 'fulfulde (latinsk, Burkina Faso)',
        'ff-Latn-CM' => 'fulfulde (latinsk, Kamerun)',
        'ff-Latn-GH' => 'fulfulde (latinsk, Ghana)',
        'ff-Latn-GM' => 'fulfulde (latinsk, Gambia)',
        'ff-Latn-GN' => 'fulfulde (latinsk, Guinea)',
        'ff-Latn-GW' => 'fulfulde (latinsk, Guinea-Bissau)',
        'ff-Latn-LR' => 'fulfulde (latinsk, Liberia)',
        'ff-Latn-MR' => 'fulfulde (latinsk, Mauritania)',
        'ff-Latn-NE' => 'fulfulde (latinsk, Niger)',
        'ff-Latn-NG' => 'fulfulde (latinsk, Nigeria)',
        'ff-Latn-SL' => 'fulfulde (latinsk, Sierra Leone)',
        'ff-Latn-SN' => 'fulfulde (latinsk, Senegal)',
        'fi' => 'finsk',
        'fi-FI' => 'finsk (Finland)',
        'fil' => 'filipino',
        'fil-PH' => 'filipino (Filippinene)',
        'fo' => 'færøysk',
        'fo-DK' => 'færøysk (Danmark)',
        'fo-FO' => 'færøysk (Færøyene)',
        'fr' => 'fransk',
        'fr-BE' => 'fransk (Belgia)',
        'fr-BF' => 'fransk (Burkina Faso)',
        'fr-BI' => 'fransk (Burundi)',
        'fr-BJ' => 'fransk (Benin)',
        'fr-BL' => 'fransk (Saint-Barthélemy)',
        'fr-CA' => 'fransk (Canada)',
        'fr-CD' => 'fransk (Kongo-Kinshasa)',
        'fr-CF' => 'fransk (Den sentralafrikanske republikk)',
        'fr-CG' => 'fransk (Kongo-Brazzaville)',
        'fr-CH' => 'fransk (Sveits)',
        'fr-CI' => 'fransk (Elfenbenskysten)',
        'fr-CM' => 'fransk (Kamerun)',
        'fr-DJ' => 'fransk (Djibouti)',
        'fr-DZ' => 'fransk (Algerie)',
        'fr-FR' => 'fransk (Frankrike)',
        'fr-GA' => 'fransk (Gabon)',
        'fr-GF' => 'fransk (Fransk Guyana)',
        'fr-GN' => 'fransk (Guinea)',
        'fr-GP' => 'fransk (Guadeloupe)',
        'fr-GQ' => 'fransk (Ekvatorial-Guinea)',
        'fr-HT' => 'fransk (Haiti)',
        'fr-KM' => 'fransk (Komorene)',
        'fr-LU' => 'fransk (Luxemburg)',
        'fr-MA' => 'fransk (Marokko)',
        'fr-MC' => 'fransk (Monaco)',
        'fr-MF' => 'fransk (Saint-Martin)',
        'fr-MG' => 'fransk (Madagaskar)',
        'fr-ML' => 'fransk (Mali)',
        'fr-MQ' => 'fransk (Martinique)',
        'fr-MR' => 'fransk (Mauritania)',
        'fr-MU' => 'fransk (Mauritius)',
        'fr-NC' => 'fransk (Ny-Caledonia)',
        'fr-NE' => 'fransk (Niger)',
        'fr-PF' => 'fransk (Fransk Polynesia)',
        'fr-PM' => 'fransk (Saint-Pierre-et-Miquelon)',
        'fr-RE' => 'fransk (Réunion)',
        'fr-RW' => 'fransk (Rwanda)',
        'fr-SC' => 'fransk (Seychellene)',
        'fr-SN' => 'fransk (Senegal)',
        'fr-SY' => 'fransk (Syria)',
        'fr-TD' => 'fransk (Tsjad)',
        'fr-TG' => 'fransk (Togo)',
        'fr-TN' => 'fransk (Tunisia)',
        'fr-VU' => 'fransk (Vanuatu)',
        'fr-WF' => 'fransk (Wallis og Futuna)',
        'fr-YT' => 'fransk (Mayotte)',
        'fur' => 'friuliansk',
        'fur-IT' => 'friuliansk (Italia)',
        'fy' => 'vestfrisisk',
        'fy-NL' => 'vestfrisisk (Nederland)',
        'ga' => 'irsk',
        'ga-IE' => 'irsk (Irland)',
        'gd' => 'skotsk-gælisk',
        'gd-GB' => 'skotsk-gælisk (Storbritannia)',
        'gl' => 'galisisk',
        'gl-ES' => 'galisisk (Spania)',
        'gsw' => 'sveitsertysk',
        'gsw-CH' => 'sveitsertysk (Sveits)',
        'gsw-FR' => 'sveitsertysk (Frankrike)',
        'gsw-LI' => 'sveitsertysk (Liechtenstein)',
        'gu' => 'gujarati',
        'gu-IN' => 'gujarati (India)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Kenya)',
        'gv' => 'mansk',
        'gv-IM' => 'mansk (Man)',
        'ha' => 'hausa',
        'ha-GH' => 'hausa (Ghana)',
        'ha-NE' => 'hausa (Niger)',
        'ha-NG' => 'hausa (Nigeria)',
        'haw' => 'hawaiisk',
        'haw-US' => 'hawaiisk (USA)',
        'he' => 'hebraisk',
        'he-IL' => 'hebraisk (Israel)',
        'hi' => 'hindi',
        'hi-IN' => 'hindi (India)',
        'hr' => 'kroatisk',
        'hr-BA' => 'kroatisk (Bosnia-Hercegovina)',
        'hr-HR' => 'kroatisk (Kroatia)',
        'hsb' => 'høysorbisk',
        'hsb-DE' => 'høysorbisk (Tyskland)',
        'hu' => 'ungarsk',
        'hu-HU' => 'ungarsk (Ungarn)',
        'hy' => 'armensk',
        'hy-AM' => 'armensk (Armenia)',
        'ia' => 'interlingua',
        'ia-001' => 'interlingua (verden)',
        'id' => 'indonesisk',
        'id-ID' => 'indonesisk (Indonesia)',
        'ig' => 'ibo',
        'ig-NG' => 'ibo (Nigeria)',
        'ii' => 'sichuan-yi',
        'ii-CN' => 'sichuan-yi (Kina)',
        'is' => 'islandsk',
        'is-IS' => 'islandsk (Island)',
        'it' => 'italiensk',
        'it-CH' => 'italiensk (Sveits)',
        'it-IT' => 'italiensk (Italia)',
        'it-SM' => 'italiensk (San Marino)',
        'it-VA' => 'italiensk (Vatikanstaten)',
        'ja' => 'japansk',
        'ja-JP' => 'japansk (Japan)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Kamerun)',
        'jmc' => 'machame',
        'jmc-TZ' => 'machame (Tanzania)',
        'jv' => 'javanesisk',
        'jv-ID' => 'javanesisk (Indonesia)',
        'ka' => 'georgisk',
        'ka-GE' => 'georgisk (Georgia)',
        'kab' => 'kabylsk',
        'kab-DZ' => 'kabylsk (Algerie)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Kenya)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzania)',
        'kea' => 'kappverdisk',
        'kea-CV' => 'kappverdisk (Kapp Verde)',
        'khq' => 'koyra chiini',
        'khq-ML' => 'koyra chiini (Mali)',
        'ki' => 'kikuyu',
        'ki-KE' => 'kikuyu (Kenya)',
        'kk' => 'kasakhisk',
        'kk-KZ' => 'kasakhisk (Kasakhstan)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Kamerun)',
        'kl' => 'grønlandsk',
        'kl-GL' => 'grønlandsk (Grønland)',
        'kln' => 'kalenjin',
        'kln-KE' => 'kalenjin (Kenya)',
        'km' => 'khmer',
        'km-KH' => 'khmer (Kambodsja)',
        'kn' => 'kannada',
        'kn-IN' => 'kannada (India)',
        'ko' => 'koreansk',
        'ko-KP' => 'koreansk (Nord-Korea)',
        'ko-KR' => 'koreansk (Sør-Korea)',
        'kok' => 'konkani',
        'kok-IN' => 'konkani (India)',
        'ks' => 'kasjmiri',
        'ks-IN' => 'kasjmiri (India)',
        'ksb' => 'shambala',
        'ksb-TZ' => 'shambala (Tanzania)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'kølnsk',
        'ksh-DE' => 'kølnsk (Tyskland)',
        'ku' => 'kurdisk',
        'ku-TR' => 'kurdisk (Tyrkia)',
        'kw' => 'kornisk',
        'kw-GB' => 'kornisk (Storbritannia)',
        'ky' => 'kirgisisk',
        'ky-KG' => 'kirgisisk (Kirgisistan)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzania)',
        'lb' => 'luxemburgsk',
        'lb-LU' => 'luxemburgsk (Luxemburg)',
        'lg' => 'ganda',
        'lg-UG' => 'ganda (Uganda)',
        'lkt' => 'lakota',
        'lkt-US' => 'lakota (USA)',
        'ln' => 'lingala',
        'ln-AO' => 'lingala (Angola)',
        'ln-CD' => 'lingala (Kongo-Kinshasa)',
        'ln-CF' => 'lingala (Den sentralafrikanske republikk)',
        'ln-CG' => 'lingala (Kongo-Brazzaville)',
        'lo' => 'laotisk',
        'lo-LA' => 'laotisk (Laos)',
        'lrc' => 'nord-luri',
        'lrc-IQ' => 'nord-luri (Irak)',
        'lrc-IR' => 'nord-luri (Iran)',
        'lt' => 'litauisk',
        'lt-LT' => 'litauisk (Litauen)',
        'lu' => 'luba-katanga',
        'lu-CD' => 'luba-katanga (Kongo-Kinshasa)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Kenya)',
        'luy' => 'luhya',
        'luy-KE' => 'luhya (Kenya)',
        'lv' => 'latvisk',
        'lv-LV' => 'latvisk (Latvia)',
        'mas' => 'masai',
        'mas-KE' => 'masai (Kenya)',
        'mas-TZ' => 'masai (Tanzania)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Kenya)',
        'mfe' => 'mauritisk-kreolsk',
        'mfe-MU' => 'mauritisk-kreolsk (Mauritius)',
        'mg' => 'gassisk',
        'mg-MG' => 'gassisk (Madagaskar)',
        'mgh' => 'makhuwa-meetto',
        'mgh-MZ' => 'makhuwa-meetto (Mosambik)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Kamerun)',
        'mi' => 'maori',
        'mi-NZ' => 'maori (New Zealand)',
        'mk' => 'makedonsk',
        'mk-MK' => 'makedonsk (Nord-Makedonia)',
        'ml' => 'malayalam',
        'ml-IN' => 'malayalam (India)',
        'mn' => 'mongolsk',
        'mn-MN' => 'mongolsk (Mongolia)',
        'mr' => 'marathi',
        'mr-IN' => 'marathi (India)',
        'ms' => 'malayisk',
        'ms-BN' => 'malayisk (Brunei)',
        'ms-MY' => 'malayisk (Malaysia)',
        'ms-SG' => 'malayisk (Singapore)',
        'mt' => 'maltesisk',
        'mt-MT' => 'maltesisk (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'burmesisk',
        'my-MM' => 'burmesisk (Myanmar [Burma])',
        'mzn' => 'mazandarani',
        'mzn-IR' => 'mazandarani (Iran)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namibia)',
        'nb' => 'norsk bokmål',
        'nb-NO' => 'norsk bokmål (Norge)',
        'nb-SJ' => 'norsk bokmål (Svalbard og Jan Mayen)',
        'nd' => 'nord-ndebele',
        'nd-ZW' => 'nord-ndebele (Zimbabwe)',
        'nds' => 'nedertysk',
        'nds-DE' => 'nedertysk (Tyskland)',
        'nds-NL' => 'nedertysk (Nederland)',
        'ne' => 'nepali',
        'ne-IN' => 'nepali (India)',
        'ne-NP' => 'nepali (Nepal)',
        'nl' => 'nederlandsk',
        'nl-AW' => 'nederlandsk (Aruba)',
        'nl-BE' => 'nederlandsk (Belgia)',
        'nl-BQ' => 'nederlandsk (Karibisk Nederland)',
        'nl-CW' => 'nederlandsk (Curaçao)',
        'nl-NL' => 'nederlandsk (Nederland)',
        'nl-SR' => 'nederlandsk (Surinam)',
        'nl-SX' => 'nederlandsk (Sint Maarten)',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Kamerun)',
        'nn' => 'norsk nynorsk',
        'nn-NO' => 'norsk nynorsk (Norge)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Kamerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Sør-Sudan)',
        'nyn' => 'nyankole',
        'nyn-UG' => 'nyankole (Uganda)',
        'om' => 'oromo',
        'om-ET' => 'oromo (Etiopia)',
        'om-KE' => 'oromo (Kenya)',
        'or' => 'odia',
        'or-IN' => 'odia (India)',
        'os' => 'ossetisk',
        'os-GE' => 'ossetisk (Georgia)',
        'os-RU' => 'ossetisk (Russland)',
        'pa' => 'panjabi',
        'pa-Arab' => 'panjabi (arabisk)',
        'pa-Arab-PK' => 'panjabi (arabisk, Pakistan)',
        'pa-Guru' => 'panjabi (gurmukhi)',
        'pa-Guru-IN' => 'panjabi (gurmukhi, India)',
        'pl' => 'polsk',
        'pl-PL' => 'polsk (Polen)',
        'ps' => 'pashto',
        'ps-AF' => 'pashto (Afghanistan)',
        'ps-PK' => 'pashto (Pakistan)',
        'pt' => 'portugisisk',
        'pt-AO' => 'portugisisk (Angola)',
        'pt-BR' => 'portugisisk (Brasil)',
        'pt-CH' => 'portugisisk (Sveits)',
        'pt-CV' => 'portugisisk (Kapp Verde)',
        'pt-GQ' => 'portugisisk (Ekvatorial-Guinea)',
        'pt-GW' => 'portugisisk (Guinea-Bissau)',
        'pt-LU' => 'portugisisk (Luxemburg)',
        'pt-MO' => 'portugisisk (Macao S.A.R. Kina)',
        'pt-MZ' => 'portugisisk (Mosambik)',
        'pt-PT' => 'portugisisk (Portugal)',
        'pt-ST' => 'portugisisk (São Tomé og Príncipe)',
        'pt-TL' => 'portugisisk (Øst-Timor)',
        'qu' => 'quechua',
        'qu-BO' => 'quechua (Bolivia)',
        'qu-EC' => 'quechua (Ecuador)',
        'qu-PE' => 'quechua (Peru)',
        'rm' => 'retoromansk',
        'rm-CH' => 'retoromansk (Sveits)',
        'rn' => 'rundi',
        'rn-BI' => 'rundi (Burundi)',
        'ro' => 'rumensk',
        'ro-MD' => 'rumensk (Moldova)',
        'ro-RO' => 'rumensk (Romania)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzania)',
        'ru' => 'russisk',
        'ru-BY' => 'russisk (Hviterussland)',
        'ru-KG' => 'russisk (Kirgisistan)',
        'ru-KZ' => 'russisk (Kasakhstan)',
        'ru-MD' => 'russisk (Moldova)',
        'ru-RU' => 'russisk (Russland)',
        'ru-UA' => 'russisk (Ukraina)',
        'rw' => 'kinyarwanda',
        'rw-RW' => 'kinyarwanda (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzania)',
        'sah' => 'sakha',
        'sah-RU' => 'sakha (Russland)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Kenya)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzania)',
        'sd' => 'sindhi',
        'sd-PK' => 'sindhi (Pakistan)',
        'se' => 'nordsamisk',
        'se-FI' => 'nordsamisk (Finland)',
        'se-NO' => 'nordsamisk (Norge)',
        'se-SE' => 'nordsamisk (Sverige)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mosambik)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Den sentralafrikanske republikk)',
        'shi' => 'tachelhit',
        'shi-Latn' => 'tachelhit (latinsk)',
        'shi-Latn-MA' => 'tachelhit (latinsk, Marokko)',
        'shi-Tfng' => 'tachelhit (tifinagh)',
        'shi-Tfng-MA' => 'tachelhit (tifinagh, Marokko)',
        'si' => 'singalesisk',
        'si-LK' => 'singalesisk (Sri Lanka)',
        'sk' => 'slovakisk',
        'sk-SK' => 'slovakisk (Slovakia)',
        'sl' => 'slovensk',
        'sl-SI' => 'slovensk (Slovenia)',
        'smn' => 'enaresamisk',
        'smn-FI' => 'enaresamisk (Finland)',
        'sn' => 'shona',
        'sn-ZW' => 'shona (Zimbabwe)',
        'so' => 'somali',
        'so-DJ' => 'somali (Djibouti)',
        'so-ET' => 'somali (Etiopia)',
        'so-KE' => 'somali (Kenya)',
        'so-SO' => 'somali (Somalia)',
        'sq' => 'albansk',
        'sq-AL' => 'albansk (Albania)',
        'sq-MK' => 'albansk (Nord-Makedonia)',
        'sq-XK' => 'albansk (Kosovo)',
        'sr' => 'serbisk',
        'sr-Cyrl' => 'serbisk (kyrillisk)',
        'sr-Cyrl-BA' => 'serbisk (kyrillisk, Bosnia-Hercegovina)',
        'sr-Cyrl-ME' => 'serbisk (kyrillisk, Montenegro)',
        'sr-Cyrl-RS' => 'serbisk (kyrillisk, Serbia)',
        'sr-Cyrl-XK' => 'serbisk (kyrillisk, Kosovo)',
        'sr-Latn' => 'serbisk (latinsk)',
        'sr-Latn-BA' => 'serbisk (latinsk, Bosnia-Hercegovina)',
        'sr-Latn-ME' => 'serbisk (latinsk, Montenegro)',
        'sr-Latn-RS' => 'serbisk (latinsk, Serbia)',
        'sr-Latn-XK' => 'serbisk (latinsk, Kosovo)',
        'sv' => 'svensk',
        'sv-AX' => 'svensk (Åland)',
        'sv-FI' => 'svensk (Finland)',
        'sv-SE' => 'svensk (Sverige)',
        'sw' => 'swahili',
        'sw-CD' => 'swahili (Kongo-Kinshasa)',
        'sw-KE' => 'swahili (Kenya)',
        'sw-TZ' => 'swahili (Tanzania)',
        'sw-UG' => 'swahili (Uganda)',
        'ta' => 'tamil',
        'ta-IN' => 'tamil (India)',
        'ta-LK' => 'tamil (Sri Lanka)',
        'ta-MY' => 'tamil (Malaysia)',
        'ta-SG' => 'tamil (Singapore)',
        'te' => 'telugu',
        'te-IN' => 'telugu (India)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Kenya)',
        'teo-UG' => 'teso (Uganda)',
        'tg' => 'tadsjikisk',
        'tg-TJ' => 'tadsjikisk (Tadsjikistan)',
        'th' => 'thai',
        'th-TH' => 'thai (Thailand)',
        'ti' => 'tigrinja',
        'ti-ER' => 'tigrinja (Eritrea)',
        'ti-ET' => 'tigrinja (Etiopia)',
        'tk' => 'turkmensk',
        'tk-TM' => 'turkmensk (Turkmenistan)',
        'to' => 'tongansk',
        'to-TO' => 'tongansk (Tonga)',
        'tr' => 'tyrkisk',
        'tr-CY' => 'tyrkisk (Kypros)',
        'tr-TR' => 'tyrkisk (Tyrkia)',
        'tt' => 'tatarisk',
        'tt-RU' => 'tatarisk (Russland)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'sentralmarokkansk tamazight',
        'tzm-MA' => 'sentralmarokkansk tamazight (Marokko)',
        'ug' => 'uigurisk',
        'ug-CN' => 'uigurisk (Kina)',
        'uk' => 'ukrainsk',
        'uk-UA' => 'ukrainsk (Ukraina)',
        'ur' => 'urdu',
        'ur-IN' => 'urdu (India)',
        'ur-PK' => 'urdu (Pakistan)',
        'uz' => 'usbekisk',
        'uz-Arab' => 'usbekisk (arabisk)',
        'uz-Arab-AF' => 'usbekisk (arabisk, Afghanistan)',
        'uz-Cyrl' => 'usbekisk (kyrillisk)',
        'uz-Cyrl-UZ' => 'usbekisk (kyrillisk, Usbekistan)',
        'uz-Latn' => 'usbekisk (latinsk)',
        'uz-Latn-UZ' => 'usbekisk (latinsk, Usbekistan)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latinsk)',
        'vai-Latn-LR' => 'vai (latinsk, Liberia)',
        'vai-Vaii' => 'vai (vai)',
        'vai-Vaii-LR' => 'vai (vai, Liberia)',
        'vi' => 'vietnamesisk',
        'vi-VN' => 'vietnamesisk (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzania)',
        'wae' => 'walsertysk',
        'wae-CH' => 'walsertysk (Sveits)',
        'wo' => 'wolof',
        'wo-SN' => 'wolof (Senegal)',
        'xh' => 'xhosa',
        'xh-ZA' => 'xhosa (Sør-Afrika)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Uganda)',
        'yav' => 'yangben',
        'yav-CM' => 'yangben (Kamerun)',
        'yi' => 'jiddisk',
        'yi-001' => 'jiddisk (verden)',
        'yo' => 'joruba',
        'yo-BJ' => 'joruba (Benin)',
        'yo-NG' => 'joruba (Nigeria)',
        'yue' => 'kantonesisk',
        'yue-Hans' => 'kantonesisk (forenklet)',
        'yue-Hans-CN' => 'kantonesisk (forenklet, Kina)',
        'yue-Hant' => 'kantonesisk (tradisjonell)',
        'yue-Hant-HK' => 'kantonesisk (tradisjonell, Hongkong S.A.R. Kina)',
        'zgh' => 'standard marrokansk tamazight',
        'zgh-MA' => 'standard marrokansk tamazight (Marokko)',
        'zh' => 'kinesisk',
        'zh-Hans' => 'kinesisk (forenklet)',
        'zh-Hans-CN' => 'kinesisk (forenklet, Kina)',
        'zh-Hans-HK' => 'kinesisk (forenklet, Hongkong S.A.R. Kina)',
        'zh-Hans-MO' => 'kinesisk (forenklet, Macao S.A.R. Kina)',
        'zh-Hans-SG' => 'kinesisk (forenklet, Singapore)',
        'zh-Hant' => 'kinesisk (tradisjonell)',
        'zh-Hant-HK' => 'kinesisk (tradisjonell, Hongkong S.A.R. Kina)',
        'zh-Hant-MO' => 'kinesisk (tradisjonell, Macao S.A.R. Kina)',
        'zh-Hant-TW' => 'kinesisk (tradisjonell, Taiwan)',
        'zu' => 'zulu',
        'zu-ZA' => 'zulu (Sør-Afrika)',
    ],
];
